<?php
session_start();
require_once '../config.php';

// Fungsi untuk mengambil saldo terakhir dari tabel saldo_koperasi
function getSaldoKoperasiTerakhir($conn) {
    try {
        $sql = "SELECT * FROM saldo_koperasi ORDER BY tanggal DESC LIMIT 1";
        $result = $conn->query($sql);
        if ($result && $result->num_rows > 0) {
            return $result->fetch_assoc();
        }
        return null;
    } catch (Exception $e) {
        error_log("Error getSaldoKoperasiTerakhir: " . $e->getMessage());
        return null;
    }
}

// Fungsi untuk mengambil saldo akhir jaitun 
function getSaldoAkhirJaitun($conn) {
    try {
        $sql = "SELECT saldo_akhir FROM data_jaitun ORDER BY tanggal DESC, id DESC LIMIT 1";
        $result = $conn->query($sql);
        
        if ($result && $result->num_rows > 0) {
            $row = $result->fetch_assoc();
            return $row['saldo_akhir'] ?? 0;
        }
        return 0;
    } catch (Exception $e) {
        error_log("Error getSaldoAkhirJaitun: " . $e->getMessage());
        return 0;
    }
}

// Fungsi untuk mengambil saldo akhir margiyanto 
function getSaldoAkhirMargiyanto($conn) {
    try {
        $sql = "SELECT saldo_akhir FROM data_margiyanto ORDER BY tanggal DESC, id DESC LIMIT 1";
        $result = $conn->query($sql);
        
        if ($result && $result->num_rows > 0) {
            $row = $result->fetch_assoc();
            return $row['saldo_akhir'] ?? 0;
        }
        return 0;
    } catch (Exception $e) {
        error_log("Error getSaldoAkhirMargiyanto: " . $e->getMessage());
        return 0;
    }
}

// Fungsi untuk mengambil saldo akhir transaksi sukarela
function getSaldoAkhirSukarela($conn) {
    try {
        $sql = "SELECT saldo_akhir FROM transaksi_sukarela ORDER BY tanggal_transaksi DESC, id DESC LIMIT 1";
        $result = $conn->query($sql);
        
        if ($result && $result->num_rows > 0) {
            $row = $result->fetch_assoc();
            return $row['saldo_akhir'] ?? 0;
        }
        return 0;
    } catch (Exception $e) {
        error_log("Error getSaldoAkhirSukarela: " . $e->getMessage());
        return 0;
    }
}

// Ambil data saldo
$saldoKoperasi = getSaldoKoperasiTerakhir($conn);
$saldoJaitun = getSaldoAkhirJaitun($conn);
$saldoMargiyanto = getSaldoAkhirMargiyanto($conn);
$saldoSukarela = getSaldoAkhirSukarela($conn);

// Format angka ke format Rupiah
function formatRupiah($angka) {
    if ($angka === null || $angka === '') {
        return 'Rp 0';
    }
    return 'Rp ' . number_format($angka, 0, ',', '.');
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Saldo Koperasi - Sistem Koperasi</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/npm/daisyui@3.9.4/dist/full.css" rel="stylesheet" type="text/css" />
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <script src="https://unpkg.com/lucide@latest"></script>
    <style>
        .bg-gradient-jaitun { background: linear-gradient(135deg, #22c55e 0%, #16a34a 100%); }
        .bg-gradient-margiyanto { background: linear-gradient(135deg, #8b5cf6 0%, #7c3aed 100%); }
        .bg-gradient-sukarela { background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%); }
    </style>
</head>
<body class="bg-base-100 min-h-screen">
    <div class="container mx-auto px-4 py-8">
        <div class="mb-8">
            <div class="flex items-center justify-between mb-6">
                <div class="flex items-center space-x-3">
                    <i data-lucide="building" class="w-8 h-8 text-primary"></i>
                    <h1 class="text-3xl font-bold">Saldo Koperasi</h1>
                </div>
                <div class="flex items-center space-x-4">
                    <span class="text-sm text-base-content/70 hidden sm:inline-block">
                        <?= date('d F Y') ?>
                    </span>
                    <button onclick="confirmLogout()" class="btn btn-error btn-sm text-white shadow-sm">
                        <i data-lucide="log-out" class="w-4 h-4 mr-1"></i>
                        Logout
                    </button>
                </div>
            </div>
            <div class="divider"></div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
            <div class="card bg-gradient-to-br from-primary to-primary-focus shadow-xl">
                <div class="card-body">
                    <div class="flex justify-between items-start">
                        <div>
                            <h2 class="card-title text-white text-lg font-semibold mb-2">Saldo Utama Koperasi</h2>
                            <p class="text-white/80 text-sm">Saldo terakhir dari sistem</p>
                        </div>
                        <i data-lucide="wallet" class="w-6 h-6 text-white"></i>
                    </div>
                    <div class="mt-4">
                        <p class="text-3xl font-bold text-white">
                            <?= formatRupiah($saldoKoperasi['saldo_utama_akhir'] ?? 0) ?>
                        </p>
                        <?php if ($saldoKoperasi): ?>
                            <p class="text-white/70 text-sm mt-1">
                                Update: <?= date('d/m/Y', strtotime($saldoKoperasi['tanggal'])) ?>
                            </p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="card bg-gradient-jaitun shadow-xl">
                <div class="card-body">
                    <div class="flex justify-between items-start">
                        <div>
                            <h2 class="card-title text-white text-lg font-semibold mb-2">Saldo Akhir Jaitun</h2>
                            <p class="text-white/80 text-sm">Total saldo dari data Jaitun</p>
                        </div>
                        <i data-lucide="leaf" class="w-6 h-6 text-white"></i>
                    </div>
                    <div class="mt-4">
                        <p class="text-3xl font-bold text-white">
                            <?= formatRupiah($saldoJaitun) ?>
                        </p>
                    </div>
                </div>
            </div>

            <div class="card bg-gradient-margiyanto shadow-xl">
                <div class="card-body">
                    <div class="flex justify-between items-start">
                        <div>
                            <h2 class="card-title text-white text-lg font-semibold mb-2">Saldo Akhir Margiyanto</h2>
                            <p class="text-white/80 text-sm">Total saldo dari data Margiyanto</p>
                        </div>
                        <i data-lucide="users" class="w-6 h-6 text-white"></i>
                    </div>
                    <div class="mt-4">
                        <p class="text-3xl font-bold text-white">
                            <?= formatRupiah($saldoMargiyanto) ?>
                        </p>
                    </div>
                </div>
            </div>

            <div class="card bg-gradient-sukarela shadow-xl">
                <div class="card-body">
                    <div class="flex justify-between items-start">
                        <div>
                            <h2 class="card-title text-white text-lg font-semibold mb-2">Saldo Transaksi Sukarela</h2>
                            <p class="text-white/80 text-sm">Total transaksi sukarela</p>
                        </div>
                        <i data-lucide="heart" class="w-6 h-6 text-white"></i>
                    </div>
                    <div class="mt-4">
                        <p class="text-3xl font-bold text-white">
                            <?= formatRupiah($saldoSukarela) ?>
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <div class="card shadow-xl">
            <div class="card-body">
                <h2 class="card-title mb-4">
                    <i data-lucide="info" class="w-5 h-5 mr-2"></i>
                    Detail Saldo Koperasi
                </h2>
                
                <?php if ($saldoKoperasi): ?>
                    <div class="space-y-4">
                        <div class="flex justify-between items-center py-3 border-b">
                            <span class="font-medium">Tanggal Update</span>
                            <span class="text-base-content/70"><?= date('d F Y', strtotime($saldoKoperasi['tanggal'])) ?></span>
                        </div>
                        
                        <div class="flex justify-between items-center py-3 border-b">
                            <span class="font-medium">Saldo Utama Awal</span>
                            <span class="font-semibold"><?= formatRupiah($saldoKoperasi['saldo_utama'] ?? 0) ?></span>
                        </div>
                        
                        <div class="flex justify-between items-center py-3 border-b">
                            <span class="font-medium">Saldo Utama Akhir</span>
                            <span class="font-bold text-primary"><?= formatRupiah($saldoKoperasi['saldo_utama_akhir'] ?? 0) ?></span>
                        </div>
                        
                        <?php if ($saldoKoperasi['keterangan']): ?>
                            <div class="flex justify-between items-start py-3">
                                <span class="font-medium">Keterangan</span>
                                <span class="text-base-content/70 text-right"><?= htmlspecialchars($saldoKoperasi['keterangan']) ?></span>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php else: ?>
                    <div class="alert alert-info">
                        <i data-lucide="info" class="w-5 h-5 mr-2"></i>
                        <span>Belum ada data saldo koperasi. Silakan tambahkan data saldo terlebih dahulu.</span>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script>
        // Initialize Lucide icons
        lucide.createIcons();
        
        // Alpine.js component for responsive features
        document.addEventListener('alpine:init', () => {
            Alpine.data('saldoKoperasi', () => ({
                init() {
                    console.log('Saldo Koperasi Component Initialized');
                }
            }));
        });

// Fungsi SweetAlert Super Simpel & Rapi
function confirmLogout() {
    Swal.fire({
        title: 'Keluar Aplikasi?',
        text: 'Apakah Anda yakin ingin mengakhiri sesi ini?',
        icon: 'warning', 
        showCancelButton: true,
        showConfirmButton: true,
        confirmButtonText: 'Ya, Logout',
        cancelButtonText: 'Batal',
        reverseButtons: true, // Tombol Batal di kiri, Logout di kanan
        // Mematikan gaya bawaan SweetAlert dan menggunakan class DaisyUI/Tailwind
        buttonsStyling: false, 
        customClass: {
            confirmButton: 'btn btn-error text-white mx-2',
            cancelButton: 'btn btn-active mx-2'
        }
    }).then((result) => {
        if (result.isConfirmed) {
            // Pastikan path ini mengarah tepat ke file logout Anda
            window.location.href = 'logout.php'; 
        }
    });
}
    </script>
</body>
</html>