<?php
include '../config.php';
session_start();

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header("Location: ../login.php");
    exit;
}

// 1. Ambil Saldo Utama Terakhir
$q_utama = mysqli_query($conn, "SELECT saldo_utama FROM saldo_koperasi ORDER BY id DESC LIMIT 1");
$last_utama = ($row = mysqli_fetch_assoc($q_utama)) ? $row['saldo_utama'] : 0;

// 2. Ambil Saldo Awal Margiyanto
$q_margi = mysqli_query($conn, "SELECT saldo_akhir FROM data_margiyanto ORDER BY id DESC LIMIT 1");
$last_margi = ($row = mysqli_fetch_assoc($q_margi)) ? $row['saldo_akhir'] : 0;

// 3. Ambil Saldo Akhir Jaitun
$q_jaitun = mysqli_query($conn, "SELECT saldo_akhir FROM data_jaitun ORDER BY id DESC LIMIT 1");
$last_jaitun = ($row = mysqli_fetch_assoc($q_jaitun)) ? $row['saldo_akhir'] : 0;
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Input Keuangan - KoperasiApp</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/lucide@latest"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; }
        input::-webkit-outer-spin-button, input::-webkit-inner-spin-button { -webkit-appearance: none; margin: 0; }
        .readonly-input { background-color: #f8fafc; cursor: not-allowed; color: #64748b; border-color: #e2e8f0; }
    </style>
</head>
<body class="bg-slate-50 text-slate-900 pb-20">

    <div class="max-w-6xl mx-auto px-4 pt-8">
        
        <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-8 gap-4">
            <div class="flex items-center gap-4">
                <a href="admin_dashboard.php" class="flex items-center justify-center w-12 h-12 bg-white rounded-2xl border border-slate-200 shadow-sm text-slate-600 hover:text-indigo-600 transition-all active:scale-95">
                    <i data-lucide="arrow-left" class="w-6 h-6"></i>
                </a>
                <div>
                    <h1 class="text-2xl font-extrabold tracking-tight text-slate-800">Update Keuangan</h1>
                    <p class="text-slate-500 text-sm font-medium">Input harian Jaitun & Margiyanto</p>
                </div>
            </div>
            <div class="bg-white p-2 rounded-2xl shadow-sm border border-slate-200 flex items-center gap-3">
                <i data-lucide="calendar" class="w-5 h-5 text-indigo-500 ml-2"></i>
                <input type="date" name="tanggal" form="financeForm" value="<?php echo date('Y-m-d'); ?>" class="bg-transparent border-none font-bold text-slate-700 outline-none focus:ring-0">
            </div>
        </div>

        <form action="proses_input.php" method="POST" id="financeForm" class="space-y-8">
            
            <div class="bg-indigo-600 rounded-[2.5rem] p-8 shadow-xl shadow-indigo-200 relative overflow-hidden text-white">
                <div class="relative z-10">
                    <p class="text-indigo-100 text-xs font-bold uppercase tracking-[0.2em] mb-2">Total Saldo Utama Koperasi</p>
                    <div class="flex items-baseline gap-2">
                        <span class="text-2xl font-bold opacity-70 text-indigo-200">Rp</span>
                        <input type="text" id="display_saldo_utama" readonly class="bg-transparent border-none text-5xl font-black text-white w-full outline-none focus:ring-0" value="<?php echo $last_utama; ?>">
                    </div>
                </div>
                <input type="hidden" name="saldo_utama" id="saldo_utama" value="<?php echo $last_utama; ?>">
                <input type="hidden" id="basis_saldo_utama" value="<?php echo $last_utama; ?>">
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                
                <?php 
                $users = [
                    ['key' => 'j', 'name' => 'Jaitun', 'color' => 'blue', 'last_saldo' => $last_jaitun],
                    ['key' => 'm', 'name' => 'Margiyanto', 'color' => 'orange', 'last_saldo' => $last_margi]
                ];

                foreach($users as $u):
                ?>
                <div class="bg-white rounded-[2.5rem] border border-slate-200 shadow-sm overflow-hidden flex flex-col">
                    <div class="p-6 border-b border-slate-100 flex justify-between items-center bg-slate-50/50">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 rounded-2xl bg-<?php echo $u['color']; ?>-100 text-<?php echo $u['color']; ?>-600 flex items-center justify-center font-bold">
                                <i data-lucide="user" class="w-5 h-5"></i>
                            </div>
                            <h3 class="font-bold text-slate-700 uppercase tracking-wider">Saving Uang <?php echo $u['name']; ?></h3>
                        </div>
                        <div class="text-right">
                            <span class="text-[10px] font-bold text-slate-400 uppercase block mb-1">Saldo Akhir</span>
                            <input type="text" data-name="<?php echo $u['key']; ?>_saldo_awal" value="<?php echo $u['last_saldo']; ?>" readonly class="format-ribu readonly-input rounded-xl px-3 py-1 text-sm font-bold w-32 text-right outline-none">
                            <input type="hidden" id="<?php echo $u['key']; ?>_basis_saldo" value="<?php echo $u['last_saldo']; ?>">
                            <input type="hidden" name="<?php echo $u['key']; ?>_saldo_awal" value="<?php echo $u['last_saldo']; ?>">
                        </div>
                    </div>

                    <div class="p-6 space-y-6">
                        <div class="space-y-4">
                            <div class="flex items-center gap-2 text-emerald-600 font-black text-[10px] uppercase tracking-widest">
                                <i data-lucide="arrow-down-to-dot" class="w-4 h-4"></i> Uang Masuk
                            </div>
                            <div class="grid grid-cols-3 gap-3">
                                <?php foreach(['sw' => 'S. Wajib', 'jasa' => 'Jasa', 'pinj' => 'Pinj.'] as $fk => $fl): ?>
                                <div class="bg-emerald-50/50 p-3 rounded-2xl border border-emerald-100">
                                    <label class="block text-[10px] font-bold text-slate-400 uppercase mb-1"><?php echo $fl; ?></label>
                                    <input type="text" data-name="<?php echo $u['key'].'_in_'.$fk; ?>" value="0" class="format-ribu hitung w-full bg-white p-2 rounded-xl border border-slate-200 text-sm font-bold outline-none focus:ring-2 focus:ring-emerald-400">
                                    <input type="hidden" name="<?php echo $u['key'].'_in_'.$fk; ?>" value="0">
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>

                        <div class="space-y-4">
                            <div class="flex items-center gap-2 text-rose-600 font-black text-[10px] uppercase tracking-widest">
                                <i data-lucide="arrow-up-from-dot" class="w-4 h-4"></i> Uang Keluar
                            </div>
                            <div class="grid grid-cols-3 gap-3">
                                <?php foreach(['sw' => 'S. Wajib', 'jasa' => 'Jasa', 'pinj' => 'Pinj.'] as $fk => $fl): ?>
                                <div class="bg-rose-50/50 p-3 rounded-2xl border border-rose-100">
                                    <label class="block text-[10px] font-bold text-slate-400 uppercase mb-1"><?php echo $fl; ?></label>
                                    <input type="text" data-name="<?php echo $u['key'].'_out_'.$fk; ?>" value="0" class="format-ribu hitung w-full bg-white p-2 rounded-xl border border-slate-200 text-sm font-bold outline-none focus:ring-2 focus:ring-rose-400">
                                    <input type="hidden" name="<?php echo $u['key'].'_out_'.$fk; ?>" value="0">
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>

                    <div class="mt-auto p-5 bg-slate-50 border-t border-slate-100 flex justify-between items-center">
                        <span class="text-[10px] font-bold text-slate-500 uppercase tracking-widest">Saldo Akhir <?php echo $u['name']; ?></span>
                        <div class="text-right">
                             <span class="text-lg font-black text-slate-800" id="display_akhir_<?php echo $u['key']; ?>">0</span>
                             <input type="hidden" name="<?php echo $u['key']; ?>_saldo_akhir" id="saldo_akhir_<?php echo $u['key']; ?>" value="0">
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>

            </div>

            <button type="submit" class="w-full bg-slate-900 text-white font-bold py-6 rounded-[2rem] shadow-xl hover:bg-indigo-700 transition-all flex items-center justify-center gap-4 group">
                <i data-lucide="check-circle" class="w-6 h-6 group-hover:scale-110 transition-transform"></i>
                <span class="uppercase tracking-widest text-sm">Simpan Transaksi</span>
            </button>
        </form>
    </div>

    <script>
        lucide.createIcons();

        const formatRupiah = (val) => val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");
        const unformat = (val) => parseFloat(val.toString().replace(/\./g, '')) || 0;

        function hitungTotal() {
            let data = {};
            
            // Sync Hidden Inputs
            document.querySelectorAll('input[type="hidden"]').forEach(h => {
                const txt = document.querySelector(`[data-name="${h.name}"]`);
                if(txt) {
                    const cleanVal = unformat(txt.value);
                    h.value = cleanVal;
                    data[h.name] = cleanVal;
                }
            });

            // Perhitungan Per User
            const users = ['j', 'm'];
            let totalGlobalMasuk = 0;
            let totalGlobalKeluar = 0;

            users.forEach(u => {
                const basis = parseFloat(document.getElementById(u + '_basis_saldo').value) || 0;
                const in_u = (data[u+'_in_sw'] || 0) + (data[u+'_in_jasa'] || 0) + (data[u+'_in_pinj'] || 0);
                const out_u = (data[u+'_out_sw'] || 0) + (data[u+'_out_jasa'] || 0) + (data[u+'_out_pinj'] || 0);
                
                const saldoAkhirUser = basis + in_u - out_u;

                document.getElementById('display_akhir_' + u).innerText = "Rp " + formatRupiah(saldoAkhirUser);
                document.getElementById('saldo_akhir_' + u).value = saldoAkhirUser;

                totalGlobalMasuk += in_u;
                totalGlobalKeluar += out_u;
            });

            // Saldo Utama Koperasi
            const basisUtama = parseFloat(document.getElementById('basis_saldo_utama').value) || 0;
            const saldoUtamaFinal = basisUtama + totalGlobalMasuk - totalGlobalKeluar;

            document.getElementById('display_saldo_utama').value = formatRupiah(saldoUtamaFinal);
            document.getElementById('saldo_utama').value = saldoUtamaFinal;
        }

        // --- Fitur Hilangkan 0 Saat Fokus ---
        document.querySelectorAll('.format-ribu:not([readonly])').forEach(input => {
            // Saat diklik / Fokus
            input.addEventListener('focus', function() {
                if (this.value === "0") {
                    this.value = "";
                }
            });

            // Saat diketik
            input.addEventListener('input', function() {
                let clean = this.value.replace(/[^0-9]/g, '');
                this.value = clean ? clean.replace(/\B(?=(\d{3})+(?!\d))/g, ".") : "";
                hitungTotal();
            });

            // Saat kursor keluar (jika kosong, kembalikan ke 0)
            input.addEventListener('blur', function() {
                if (this.value === "") {
                    this.value = "0";
                }
            });
        });

        window.onload = () => {
            document.querySelectorAll('.format-ribu').forEach(i => {
                let val = i.value.replace(/[^0-9]/g, '');
                i.value = val ? val.replace(/\B(?=(\d{3})+(?!\d))/g, ".") : "0";
            });
            hitungTotal();
        };
    </script>
</body>
</html>