<?php
include '../config.php';
session_start();

// 1. Proteksi Halaman
if (!isset($_SESSION['username']) || ($_SESSION['username'] !== 'jaitun' && $_SESSION['role'] !== 'user')) {
    header("Location: ../login.php");
    exit;
}

// Inisialisasi variabel alert
$swal_response = null;

// Ambil Saldo Awal Jaitun (Terakhir)
$query_last = "SELECT saldo_akhir FROM data_jaitun ORDER BY tanggal DESC, id DESC LIMIT 1"; 
$result_last = mysqli_query($conn, $query_last);
$data_last = mysqli_fetch_assoc($result_last);
$saldo_terakhir_db = $data_last ? (float)$data_last['saldo_akhir'] : 0; 

// Ambil Saldo Utama Koperasi
$query_saldo_koperasi = "SELECT saldo_utama_akhir FROM saldo_koperasi ORDER BY id DESC LIMIT 1";
$result_saldo_koperasi = mysqli_query($conn, $query_saldo_koperasi);
$data_saldo_koperasi = mysqli_fetch_assoc($result_saldo_koperasi);
$saldo_utama_akhir_db = $data_saldo_koperasi ? (float)$data_saldo_koperasi['saldo_utama_akhir'] : 0;

// 2. Proses Form Submit
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $tanggal = $_POST['tanggal'];
    
    // --- DATA TRANSIT (TRANSFER KELUAR) ---
    $transit_ke      = $_POST['transit_ke']; 
    $transit_nominal = str_replace('.', '', $_POST['transit_nominal']);
    if($transit_nominal == "") $transit_nominal = 0;
    
    // --- DATA PEMASUKAN JAITUN ---
    $simpanan_wajib    = str_replace('.', '', $_POST['simpanan_wajib']);
    $tata_usaha        = str_replace('.', '', $_POST['tata_usaha']);
    $angsuran_pinjaman = str_replace('.', '', $_POST['angsuran_pinjaman']);
    $jasa              = str_replace('.', '', $_POST['jasa']);

    $simpanan_wajib    = $simpanan_wajib ?: 0;
    $tata_usaha        = $tata_usaha ?: 0;
    $angsuran_pinjaman = $angsuran_pinjaman ?: 0;
    $jasa              = $jasa ?: 0;

    if (empty($tanggal)) {
        $swal_response = ['type' => 'error', 'title' => 'Gagal!', 'text' => 'Tanggal wajib diisi.'];
    } else {
        
        // --- 1. LOGIKA JAITUN (PENGIRIM - BERKURANG) ---
        $total_pemasukan_harian = (float)$simpanan_wajib + (float)$tata_usaha + (float)$angsuran_pinjaman + (float)$jasa;
        $saldo_awal_transaksi = $saldo_terakhir_db; 
        
        $saldo_akhir_baru = ($saldo_awal_transaksi + $total_pemasukan_harian) - (float)$transit_nominal;

        $saldo_utama_awal = $saldo_utama_akhir_db;
        $saldo_utama_akhir_baru = $saldo_utama_awal + $total_pemasukan_harian;

        $update_pinjaman = 0;
        if ($angsuran_pinjaman > 0) {
            $update_pinjaman = -1 * abs($angsuran_pinjaman); 
        }

        $jenis_transaksi = 'Masuk';

        // Simpan Data Jaitun
        $query = "INSERT INTO data_jaitun 
                  (tanggal, jenis_transaksi, transit_via, transit_nominal, simpanan_wajib, tata_usaha, angsuran_pinjaman, jasa, pinjaman, saldo_awal, saldo_akhir) 
                  VALUES 
                  ('$tanggal', '$jenis_transaksi', '$transit_ke', '$transit_nominal', '$simpanan_wajib', '$tata_usaha', '$angsuran_pinjaman', '$jasa', '$update_pinjaman', '$saldo_awal_transaksi', '$saldo_akhir_baru') 
                  ON DUPLICATE KEY UPDATE 
                  transit_via = '$transit_ke',
                  transit_nominal = '$transit_nominal',
                  simpanan_wajib = '$simpanan_wajib',
                  tata_usaha = '$tata_usaha',
                  angsuran_pinjaman = '$angsuran_pinjaman',
                  jasa = '$jasa',
                  pinjaman = '$update_pinjaman',
                  saldo_awal = '$saldo_awal_transaksi',
                  saldo_akhir = '$saldo_akhir_baru'";

        $simpan_Jaitun = mysqli_query($conn, $query);

        // Update Saldo Koperasi
        $query_update_saldo_koperasi = "INSERT INTO saldo_koperasi (tanggal, saldo_utama, saldo_utama_akhir, keterangan) 
                                        VALUES ('$tanggal', '$saldo_utama_awal', '$saldo_utama_akhir_baru', 'Update dari input uang masuk Jaitun') 
                                        ON DUPLICATE KEY UPDATE 
                                        saldo_utama = '$saldo_utama_awal',
                                        saldo_utama_akhir = '$saldo_utama_akhir_baru'";
        $update_saldo_koperasi = mysqli_query($conn, $query_update_saldo_koperasi);

        // Logika Transit Penerima (Sesuai struktur Anda)
        $transfer_sukses = true;
        if (!empty($transit_ke) && $transit_nominal > 0) {
            $tabel_target = "";
            if ($transit_ke == 'Margiyanto') $tabel_target = "data_margiyanto";
            elseif ($transit_ke == 'Maulana') $tabel_target = "data_maulana";

            if ($tabel_target != "") {
                $q_cek_saldo_target = "SELECT saldo_akhir FROM $tabel_target ORDER BY tanggal DESC, id DESC LIMIT 1";
                $r_cek_saldo_target = mysqli_query($conn, $q_cek_saldo_target);
                $d_cek_saldo_target = mysqli_fetch_assoc($r_cek_saldo_target);
                $saldo_lalu_target = $d_cek_saldo_target ? $d_cek_saldo_target['saldo_akhir'] : 0;

                $saldo_awal_target_set = $saldo_lalu_target;
                $saldo_akhir_target_set = $saldo_awal_target_set + $transit_nominal;
                $ket_transit = "Terima dari Jaitun";

                $query_transfer = "INSERT INTO $tabel_target (tanggal, saldo_awal, keterangan, saldo_akhir) 
                                   VALUES ('$tanggal', '$saldo_awal_target_set', '$ket_transit', '$saldo_akhir_target_set') 
                                   ON DUPLICATE KEY UPDATE 
                                   saldo_akhir = saldo_akhir + $transit_nominal,
                                   keterangan = CONCAT(keterangan, ', + $ket_transit')"; 
                if (!mysqli_query($conn, $query_transfer)) $transfer_sukses = false;
            }
        }

        if ($simpan_Jaitun && $update_saldo_koperasi && $transfer_sukses) {
            $msg_html = "Saldo Akhir Jaitun: <b>Rp " . number_format($saldo_akhir_baru,0,',','.') . "</b><br>";
            if($transit_nominal > 0) $msg_html .= "Dikirim ke $transit_ke: <b>Rp " . number_format($transit_nominal,0,',','.') . "</b>";
            
            $swal_response = ['type' => 'success', 'title' => 'Berhasil!', 'html' => $msg_html];
            $saldo_terakhir_db = $saldo_akhir_baru;
            $saldo_utama_akhir_db = $saldo_utama_akhir_baru;
        } else {
            $swal_response = ['type' => 'error', 'title' => 'Gagal', 'text' => mysqli_error($conn)];
        }
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Input Uang Masuk Jaitun</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;600;700;800&display=swap" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; }
        .swal2-popup { border-radius: 2rem !important; }
    </style>
</head>
<body class="bg-slate-50 min-h-screen pb-10">

    <nav class="bg-slate-900 text-white shadow-lg p-4 sticky top-0 z-40">
        <div class="max-w-xl mx-auto flex justify-between items-center">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-green-600 rounded-xl flex items-center justify-center font-bold text-white">
                    <i class="fa-solid fa-arrow-down"></i>
                </div>
                <div>
                    <h1 class="font-bold text-lg leading-tight">Uang Masuk Jaitun</h1>
                    <p class="text-[10px] text-slate-400 uppercase tracking-widest font-bold">Monitoring & Transit</p>
                </div>
            </div>
            <a href="jaitun_view.php" class="w-9 h-9 flex items-center justify-center bg-white/10 rounded-full hover:bg-white/20 transition-all">
                <i class="fa-solid fa-times"></i>
            </a>
        </div>
    </nav>

    <main class="max-w-xl mx-auto p-4 space-y-5">
        
        <div class="grid grid-cols-2 gap-3">
            <div class="bg-indigo-600 p-4 rounded-3xl shadow-lg shadow-indigo-100 text-white transition-all">
                <p class="text-[10px] font-bold opacity-70 uppercase mb-1">Saldo Jaitun Akhir</p>
                <h2 id="card_jaitun" class="text-lg font-extrabold tracking-tight">Rp <?= number_format($saldo_terakhir_db, 0, ',', '.') ?></h2>
            </div>
            <div class="bg-emerald-600 p-4 rounded-3xl shadow-lg shadow-emerald-100 text-white transition-all">
                <p class="text-[10px] font-bold opacity-70 uppercase mb-1">Saldo Koperasi Akhir</p>
                <h2 id="card_kop" class="text-lg font-extrabold tracking-tight">Rp <?= number_format($saldo_utama_akhir_db, 0, ',', '.') ?></h2>
            </div>
        </div>

        <form id="formMasuk" action="" method="POST" class="space-y-5" autocomplete="off">
            <input type="hidden" id="base_jaitun" value="<?= $saldo_terakhir_db ?>">
            <input type="hidden" id="base_kop" value="<?= $saldo_utama_akhir_db ?>">

            <div class="bg-white p-5 rounded-3xl shadow-sm border border-slate-100">
                <label class="block text-xs font-bold text-slate-400 uppercase tracking-wider mb-2">Tanggal Transaksi</label>
                <input type="date" name="tanggal" required value="<?= date('Y-m-d') ?>" class="w-full bg-slate-50 border border-slate-200 text-slate-800 text-sm rounded-2xl p-4 font-bold outline-none focus:ring-2 focus:ring-green-500 transition-all">
            </div>

            <div class="bg-orange-50 p-6 rounded-3xl border border-orange-100 shadow-sm relative overflow-hidden">
                <div class="flex items-center gap-2 mb-4">
                    <i class="fa-solid fa-paper-plane text-orange-500"></i>
                    <h3 class="font-bold text-orange-900 text-sm">Transit Uang Keluar</h3>
                </div>
                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="block text-[10px] font-bold text-orange-400 uppercase mb-1">Ke Siapa?</label>
                        <select name="transit_ke" class="w-full bg-white border border-orange-200 text-slate-700 text-xs rounded-xl p-3 font-bold outline-none">
                            <option value="">- Tidak Ada -</option>
                            <option value="Margiyanto">Margiyanto</option>
                            <option value="Maulana">Maulana</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-[10px] font-bold text-orange-400 uppercase mb-1">Nominal (Mengurangi)</label>
                        <input type="text" name="transit_nominal" id="input_transit" placeholder="0" onkeyup="formatRupiah(this); hitungEstimasi();" class="w-full bg-white border border-orange-200 text-slate-800 text-xs rounded-xl p-3 font-bold outline-none">
                    </div>
                </div>
            </div>

            <div class="bg-white p-6 rounded-3xl shadow-sm border border-slate-100 space-y-4">
                <h3 class="font-bold text-slate-800 text-sm flex items-center gap-2 mb-2">
                    <span class="w-1.5 h-4 bg-green-500 rounded-full"></span> Rincian Pemasukan
                </h3>
                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="block text-[10px] font-bold text-slate-500 uppercase mb-1">Simpanan Wajib</label>
                        <input type="text" name="simpanan_wajib" onkeyup="formatRupiah(this); hitungEstimasi();" class="input-hitung bg-slate-50 border border-slate-200 w-full rounded-xl p-3 font-bold text-sm outline-none">
                    </div>
                <div>
                    <label class="block text-[10px] font-bold text-slate-500 uppercase mb-1">Tata Usaha</label>
                    <input type="text" name="tata_usaha" onkeyup="formatRupiah(this); hitungJasaOtomatis();" class="input-hitung bg-slate-50 border border-slate-200 w-full rounded-xl p-3 font-bold text-sm outline-none">
                </div>
                </div>
                <div>
                    <label class="block text-[10px] font-bold text-emerald-600 uppercase mb-1">Jasa / Bunga</label>
                    <input type="text" name="jasa" onkeyup="formatRupiah(this); hitungEstimasi();" class="input-hitung bg-emerald-50 border border-emerald-100 w-full rounded-xl p-3 font-bold text-emerald-800 text-sm outline-none">
                </div>
                <div class="pt-2 border-t border-dashed border-slate-200">
                    <label class="block text-[10px] font-bold text-green-600 uppercase mb-1">Angsuran Pinjaman</label>
                    <input type="text" name="angsuran_pinjaman" onkeyup="formatRupiah(this); hitungJasaOtomatis();" class="input-hitung bg-green-50 border border-green-100 w-full rounded-xl p-3 font-bold text-slate-800 text-sm outline-none">
                </div>
            </div>

            <button type="submit" class="w-full text-white bg-slate-900 hover:bg-slate-800 font-bold rounded-2xl text-sm px-5 py-4 shadow-xl flex justify-center items-center gap-3 transition-all active:scale-95">
                <i class="fa-solid fa-floppy-disk"></i> Simpan Transaksi
            </button>
        </form>
    </main>

    <script>
// Fungsi Formatter Rupiah (Tetap)
        function formatRupiah(input) {
            let value = input.value.replace(/\D/g, "");
            input.value = value ? new Intl.NumberFormat('id-ID').format(value) : "";
        }

        // Fungsi Ambil Angka (Tetap)
        function parseNum(inputName) {
            let el = document.getElementsByName(inputName)[0];
            if(!el) return 0; // proteksi jika elemen tidak ada
            let val = el.value.replace(/\./g, "");
            return parseFloat(val) || 0;
        }

        // --- FUNGSI BARU: HITUNG JASA OTOMATIS 3% ---
        function hitungJasaOtomatis() {
            // 1. Ambil nilai Tata Usaha & Angsuran
            let valTataUsaha = parseNum('tata_usaha');
            let valAngsuran  = parseNum('angsuran_pinjaman');

            // 2. Hitung 3% dari (Tata Usaha + Angsuran)
            let totalDasar = valTataUsaha + valAngsuran;
            let hasilJasa  = totalDasar * 0.03;

            // 3. Pembulatan (Round) agar tidak ada koma
            hasilJasa = Math.round(hasilJasa);

            // 4. Masukkan ke kolom Jasa
            let inputJasa = document.getElementsByName('jasa')[0];
            inputJasa.value = new Intl.NumberFormat('id-ID').format(hasilJasa);

            // 5. Update Estimasi Kartu Atas (Penting agar saldo update)
            hitungEstimasi();
        }

        // FUNGSI HITUNG ESTIMASI SALDO (Tetap)
        function hitungEstimasi() {
            const baseJaitun = parseFloat(document.getElementById('base_jaitun').value);
            const baseKop = parseFloat(document.getElementById('base_kop').value);

            let totalMasuk = parseNum('simpanan_wajib') + parseNum('tata_usaha') + parseNum('jasa') + parseNum('angsuran_pinjaman');
            let transit = parseNum('transit_nominal');

            let estimasiJaitun = (baseJaitun + totalMasuk) - transit;
            let estimasiKop = baseKop + totalMasuk;

            document.getElementById('card_jaitun').innerText = "Rp " + new Intl.NumberFormat('id-ID').format(estimasiJaitun);
            document.getElementById('card_kop').innerText = "Rp " + new Intl.NumberFormat('id-ID').format(estimasiKop);
        }
        
        // SWEETALERT KONFIRMASI SAAT KLIK SIMPAN
        document.getElementById('formMasuk').addEventListener('submit', function(e) {
            e.preventDefault();
            const form = this;

            Swal.fire({
                title: 'Konfirmasi Simpan',
                text: "Apakah data transaksi yang Anda masukkan sudah benar?",
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#0f172a',
                cancelButtonColor: '#64748b',
                confirmButtonText: 'Ya, Simpan!',
                cancelButtonText: 'Batal',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit();
                }
            });
        });

        // Notifikasi setelah proses simpan dari PHP
        <?php if ($swal_response): ?>
            Swal.fire({
                icon: '<?= $swal_response['type'] ?>',
                title: '<?= $swal_response['title'] ?>',
                html: '<?= isset($swal_response['html']) ? $swal_response['html'] : $swal_response['text'] ?>',
                confirmButtonColor: '#0f172a'
            });
        <?php endif; ?>
    </script>
</body>
</html>