<?php
include '../config.php';
session_start();

// 1. Proteksi Halaman
if (!isset($_SESSION['username']) || ($_SESSION['username'] !== 'jaitun' && $_SESSION['role'] !== 'user')) {
    header("Location: ../login.php");
    exit;
}

/** * 2. LOGIKA UTAMA: AMBIL DATA TRANSAKSI TERAKHIR MEMBER (Untuk Card Kiri)
 */
$query_last = "SELECT * FROM data_jaitun ORDER BY tanggal DESC, id DESC LIMIT 1";
$result_last = mysqli_query($conn, $query_last);
$data_last   = mysqli_fetch_assoc($result_last);

// Penanganan jika data masih kosong
if ($data_last) {
    $saldo_akhir_card = $data_last['saldo_akhir'];
    $tgl_laporan      = $data_last['tanggal'];
    $saldo_awal_last  = $data_last['saldo_awal'];
} else {
    $saldo_akhir_card = 0;
    $tgl_laporan      = date('Y-m-d');
    $saldo_awal_last  = 0;
}

/** * 3. LOGIKA RINCIAN KOMPONEN (Untuk Card Kecil-Kecil di Bawah)
 * Bagian ini tetap dibutuhkan untuk menampilkan rincian SW, Jasa, Pinjaman, dll.
 */
$query_total = "SELECT 
    -- 1. Logic untuk Simpanan Wajib & Jasa (Berkurang jika Keluar)
    SUM(CASE 
        WHEN jenis_transaksi = 'Keluar' THEN -simpanan_wajib 
        ELSE simpanan_wajib 
    END) as total_sw,
    
    SUM(CASE 
        WHEN jenis_transaksi = 'Keluar' THEN -jasa 
        ELSE jasa 
    END) as total_jasa,

    -- 2. Logic Pengecualian untuk Pinjaman (Tetap SUM biasa)
    SUM(pinjaman_2025) as total_p2025,
    SUM(pinjaman) as total_pinj,
    SUM(pinjaman_tertahan) as total_tertahan,
    
    -- 3. Logic untuk Tata Usaha (Berkurang jika Keluar)
    SUM(CASE 
        WHEN jenis_transaksi = 'Keluar' THEN -tata_usaha 
        ELSE tata_usaha 
    END) as total_tata_usaha

FROM data_jaitun";

$result_total = mysqli_query($conn, $query_total);
if (!$result_total) {
    die("Query Error: " . mysqli_error($conn));
}
$row_total = mysqli_fetch_assoc($result_total);

// Variabel untuk Card Kecil
$pinjaman_2025  = $row_total['total_p2025'] ?? 0;
$simpanan_wajib = $row_total['total_sw'] ?? 0; 
$jasa           = $row_total['total_jasa'] ?? 0;
$pinjaman       = $row_total['total_pinj'] ?? 0;
$p_tertahan     = $row_total['total_tertahan'] ?? 0;
$tata_usaha     = $row_total['total_tata_usaha'] ?? 0;


/** * 4. AMBIL SALDO UTAMA REAL (DIPERBAIKI)
 * Tidak perlu rumus penjumlahan manual.
 * Kita ambil langsung dari 'saldo_utama_akhir' di tabel 'saldo_koperasi'.
 * Ini menjamin angka di Dashboard SAMA PERSIS dengan di Riwayat.
 */
$query_koperasi = "SELECT saldo_utama_akhir FROM saldo_koperasi ORDER BY id DESC LIMIT 1";
$result_koperasi = mysqli_query($conn, $query_koperasi);
$data_koperasi = mysqli_fetch_assoc($result_koperasi);

// Gunakan 'saldo_utama_akhir', jika null maka 0
$kas_koperasi_saat_ini = $data_koperasi['saldo_utama_akhir'] ?? 0;

?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Dashboard Jaitun - Koperasi Mandiri</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/lucide@latest"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; -webkit-tap-highlight-color: transparent; }
        .mobile-closed { transform: translateY(100%); }
        .mobile-open { transform: translateY(0); }
        #mobileMenuContent { transition: transform 0.3s cubic-bezier(0.4, 0, 0.2, 1); }
        .dropdown-animate { transform-origin: top right; transition: all 0.2s ease-out; }
    </style>
</head>
<body class="bg-[#f8fafc] min-h-screen pb-24 md:pb-10 text-slate-900">

    <nav class="hidden md:block bg-slate-900 text-white shadow-lg p-4 sticky top-0 z-[100]">
        <div class="max-w-6xl mx-auto flex justify-between items-center">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-orange-500 rounded-xl flex items-center justify-center font-bold text-white shadow-lg shadow-orange-500/20 text-xl">J</div>
                <div>
                    <h1 class="font-bold text-lg leading-tight">Koperasi Mandiri</h1>
                    <p class="text-[10px] text-slate-400 uppercase tracking-widest font-bold">Panel Anggota: Jaitun</p>
                </div>
            </div>
            
            <div class="flex items-center gap-6">
                <a href="riwayat.php" class="flex items-center gap-2 text-sm font-bold text-slate-300 hover:text-white transition-colors">
                    <i data-lucide="history" class="w-4 h-4"></i> Riwayat
                </a>
                
                <div class="relative group">
                    <button id="desktopDropdownBtn" onclick="toggleDesktopDropdown()" class="flex items-center gap-2 bg-orange-600 hover:bg-orange-700 px-5 py-2.5 rounded-xl text-sm font-bold transition-all shadow-lg shadow-orange-600/20">
                        <i data-lucide="plus-circle" class="w-4 h-4"></i>
                        Input Transaksi
                        <i data-lucide="chevron-down" id="desktopChevron" class="w-4 h-4 transition-transform duration-200"></i>
                    </button>
                    <div id="desktopDropdownMenu" class="hidden absolute right-0 mt-3 w-56 bg-white rounded-2xl shadow-2xl border border-slate-100 overflow-hidden text-slate-700 dropdown-animate z-[110]">
                        <div class="p-2">
                            <a href="input_masuk.php" class="flex items-center gap-3 px-4 py-3 hover:bg-emerald-50 hover:text-emerald-700 rounded-xl transition-colors group">
                                <div class="p-2 bg-emerald-100 text-emerald-600 rounded-lg group-hover:bg-emerald-200">
                                    <i data-lucide="trending-up" class="w-4 h-4"></i>
                                </div>
                                <span class="text-sm font-bold">Uang Masuk</span>
                            </a>
                            <a href="input_keluar.php" class="flex items-center gap-3 px-4 py-3 hover:bg-rose-50 hover:text-rose-700 rounded-xl transition-colors group">
                                <div class="p-2 bg-rose-100 text-rose-600 rounded-lg group-hover:bg-rose-200">
                                    <i data-lucide="trending-down" class="w-4 h-4"></i>
                                </div>
                                <span class="text-sm font-bold">Uang Keluar</span>
                            </a>
                        </div>
                    </div>
                </div>

                <a href="../logout.php" onclick="return confirm('Keluar dari sistem?')" class="flex items-center gap-2 bg-slate-800 hover:bg-red-600 px-5 py-2.5 rounded-xl text-sm font-bold transition-all border border-slate-700">
                    <i data-lucide="log-out" class="w-4 h-4"></i> Logout
                </a>
            </div>
        </div>
    </nav>

    <header class="md:hidden bg-white px-5 pt-12 pb-4 sticky top-0 z-40 border-b border-slate-100 flex justify-between items-center shadow-[0_4px_20px_-10px_rgba(0,0,0,0.05)]">
        <div>
            <p class="text-[10px] text-slate-400 font-bold uppercase tracking-wider">Dashboard Anggota</p>
            <h1 class="text-xl font-extrabold text-slate-800">Jaitun <span class="inline-flex items-center justify-center w-5 h-5 bg-blue-100 rounded-full ml-1"><i data-lucide="check" class="w-3 h-3 text-blue-600"></i></span></h1>
        </div>
        <a href="../logout.php" onclick="return confirm('Logout sekarang?')" class="w-11 h-11 bg-rose-50 rounded-2xl flex items-center justify-center text-rose-500 active:scale-90 transition-all border border-rose-100 shadow-sm">
            <i data-lucide="power" class="w-5 h-5"></i>
        </a>
    </header>

    <main class="max-w-6xl mx-auto p-5 md:p-8">
        
        <div class="flex items-center gap-2 mb-6 bg-white text-slate-600 px-4 py-2 rounded-full text-[11px] font-bold w-fit mx-auto md:mx-0 border border-slate-200 shadow-sm">
            <i data-lucide="calendar-days" class="w-3.5 h-3.5 text-orange-500"></i>
            Update Terakhir: <?= date('d F Y', strtotime($tgl_laporan)) ?>
        </div>

        <div class="relative bg-gradient-to-br from-slate-900 via-slate-800 to-indigo-900 rounded-[2.5rem] p-8 md:p-12 shadow-2xl shadow-indigo-200 mb-8 overflow-hidden text-white border border-slate-700">
            <div class="relative z-10 grid md:grid-cols-2 gap-8 items-center">
                <div>
                    <p class="text-indigo-200 text-xs font-bold uppercase tracking-[0.2em] mb-3 opacity-80">Saldo Akhir</p>
                    <h3 class="text-4xl md:text-6xl font-black tracking-tighter mb-4">
                        <span class="text-orange-500 text-2xl md:text-4xl mr-1 font-normal">Rp</span><?= number_format($saldo_akhir_card, 0, ',', '.') ?>
                    </h3>
                    <div class="inline-flex items-center gap-2 bg-white/10 backdrop-blur-md px-4 py-2 rounded-full border border-white/20 text-[10px] font-bold uppercase text-indigo-100">
                        <i data-lucide="wallet" class="w-3 h-3 text-emerald-400"></i>
                        Dana Pribadi (Realtime)
                    </div>
                </div>

                <div class="md:text-right">
                    <div class="bg-white/10 backdrop-blur-lg p-6 rounded-[2rem] border border-white/10 inline-block min-w-[280px]">
                        <p class="text-[10px] font-bold uppercase mb-2 text-indigo-200 tracking-[0.1em] flex items-center justify-end gap-2">
                            <i data-lucide="building-2" class="w-3 h-3"></i> saldo utama saat ini
                        </p>
                        <p class="text-2xl md:text-3xl font-black text-white">
                            Rp <?= number_format($kas_koperasi_saat_ini, 0, ',', '.') ?>
                        </p>
                        <div class="mt-2 h-1 w-full bg-white/10 rounded-full overflow-hidden">
                            <div class="h-full bg-orange-500 w-2/3 rounded-full"></div>
                        </div>
                        <p class="text-[9px] text-white/60 mt-2 italic text-right">*Total Aset Likuid Koperasi</p>
                    </div>
                </div>
            </div>
            
            <div class="absolute -right-20 -bottom-20 w-80 h-80 bg-orange-600/20 rounded-full blur-[80px]"></div>
            <div class="absolute -left-20 -top-20 w-60 h-60 bg-indigo-500/20 rounded-full blur-[80px]"></div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
            
            <div class="bg-white p-6 rounded-[2rem] border border-slate-100 shadow-sm flex items-center justify-between group hover:border-orange-100 transition-colors">
                <div>
                    <p class="text-[10px] text-slate-400 font-bold uppercase mb-1">Saldo Awal</p>
                    <p class="text-lg font-bold text-slate-800">Rp <?= number_format($saldo_awal_last, 0, ',', '.') ?></p>
                </div>
                <div class="w-12 h-12 bg-slate-50 text-slate-400 group-hover:bg-orange-50 group-hover:text-orange-500 rounded-2xl flex items-center justify-center transition-colors">
                    <i data-lucide="landmark"></i>
                </div>
            </div>

            <div class="bg-white p-6 rounded-[2rem] border border-indigo-50 shadow-sm flex items-center justify-between">
                <div>
                    <p class="text-[10px] text-indigo-500 font-bold uppercase mb-1">Simpanan Wajib (-)</p>
                    <p class="text-lg font-bold text-indigo-900">Rp <?= number_format($simpanan_wajib, 0, ',', '.') ?></p>
                </div>
                <div class="w-12 h-12 bg-indigo-50 text-indigo-600 rounded-2xl flex items-center justify-center">
                    <i data-lucide="piggy-bank"></i>
                </div>
            </div>

            <div class="bg-white p-6 rounded-[2rem] border border-emerald-50 shadow-sm flex items-center justify-between">
                <div>
                    <p class="text-[10px] text-emerald-600 font-bold uppercase mb-1">Jasa / SHU (-)</p>
                    <p class="text-lg font-bold text-emerald-900">Rp <?= number_format($jasa, 0, ',', '.') ?></p>
                </div>
                <div class="w-12 h-12 bg-emerald-50 text-emerald-600 rounded-2xl flex items-center justify-center">
                    <i data-lucide="percent"></i>
                </div>
            </div>

            <div class="bg-white p-6 rounded-[2rem] border border-amber-50 shadow-sm flex items-center justify-between">
                <div>
                    <p class="text-[10px] text-amber-600 font-bold uppercase mb-1">Tata Usaha (-)</p>
                    <p class="text-lg font-bold text-amber-900">Rp <?= number_format($tata_usaha, 0, ',', '.') ?></p>
                </div>
                <div class="w-12 h-12 bg-amber-50 text-amber-600 rounded-2xl flex items-center justify-center">
                    <i data-lucide="file-text"></i>
                </div>
            </div>

            <div class="bg-white p-6 rounded-[2rem] border border-rose-50 shadow-sm flex items-center justify-between relative overflow-hidden">
                <div class="absolute top-0 right-0 w-16 h-16 bg-rose-50 rounded-bl-[2rem] -mr-4 -mt-4"></div>
                <div class="relative z-10">
                    <p class="text-[10px] text-rose-500 font-bold uppercase mb-1">Pinjaman 2025 (-)</p>
                    <p class="text-lg font-bold text-rose-700">Rp <?= number_format($pinjaman_2025, 0, ',', '.') ?></p>
                </div>
                <div class="w-12 h-12 bg-rose-100 text-rose-600 rounded-2xl flex items-center justify-center relative z-10">
                    <i data-lucide="calendar-clock"></i>
                </div>
            </div>

            <div class="bg-white p-6 rounded-[2rem] border border-rose-50 shadow-sm flex items-center justify-between">
                <div>
                    <p class="text-[10px] text-rose-500 font-bold uppercase mb-1">Pinjaman Lainnya (-)</p>
                    <p class="text-lg font-bold text-rose-700">Rp <?= number_format($pinjaman, 0, ',', '.') ?></p>
                </div>
                <div class="w-12 h-12 bg-rose-50 text-rose-400 rounded-2xl flex items-center justify-center">
                    <i data-lucide="banknote"></i>
                </div>
            </div>

            <div class="bg-slate-100 p-6 rounded-[2rem] border border-dashed border-slate-300 flex items-center justify-between">
                <div>
                    <p class="text-[10px] text-slate-500 font-bold uppercase mb-1 italic">Pinj. Tertahan</p>
                    <p class="text-lg font-bold text-slate-600">Rp <?= number_format($p_tertahan, 0, ',', '.') ?></p>
                </div>
                <div class="w-12 h-12 bg-slate-200 text-slate-400 rounded-2xl flex items-center justify-center">
                    <i data-lucide="lock"></i>
                </div>
            </div>
        </div>

        <p class="mt-16 text-center text-slate-400 text-[10px] uppercase tracking-[0.4em] font-bold">
            &copy; 2026 Koperasi PSHT Curug
        </p>
    </main>

    <nav class="md:hidden fixed bottom-0 left-0 w-full bg-white/90 backdrop-blur-xl border-t border-slate-200 pb-safe z-50 shadow-[0_-10px_25px_rgba(0,0,0,0.05)]">
        <div class="grid grid-cols-3 h-20 items-center">
            <a href="#" class="flex flex-col items-center gap-1 text-orange-600">
                <i data-lucide="layout-dashboard" class="w-6 h-6"></i>
                <span class="text-[10px] font-bold uppercase tracking-wider">Dash</span>
            </a>
            <div class="relative flex justify-center">
                <button onclick="toggleMobileMenu()" class="absolute -top-10 w-16 h-16 bg-slate-900 rounded-full text-white shadow-xl shadow-slate-900/30 border-[6px] border-slate-50 flex items-center justify-center active:scale-90 transition-all duration-300">
                    <i data-lucide="plus" id="mobileMenuIcon" class="w-8 h-8 transition-transform duration-300"></i>
                </button>
            </div>
            <a href="riwayat.php" class="flex flex-col items-center gap-1 text-slate-400 hover:text-slate-600 transition-colors">
                <i data-lucide="history" class="w-6 h-6"></i>
                <span class="text-[10px] font-bold uppercase tracking-wider">Riwayat</span>
            </a>
        </div>
    </nav>

    <div id="mobileBackdrop" onclick="toggleMobileMenu()" class="fixed inset-0 bg-slate-900/60 z-[60] hidden backdrop-blur-sm transition-opacity duration-300"></div>
    <div id="mobileMenuContent" class="fixed bottom-0 left-0 w-full bg-white rounded-t-[3rem] z-[70] mobile-closed md:hidden shadow-2xl transition-all duration-300 border-t border-slate-100">
        <div class="flex justify-center pt-4 pb-6"><div class="w-12 h-1.5 bg-slate-200 rounded-full"></div></div>
        <div class="px-8 pb-12">
            <div class="mb-8 text-center">
                <h3 class="text-xl font-extrabold text-slate-800 tracking-tight">Transaksi Baru</h3>
                <p class="text-xs text-slate-500 font-medium">Catat pemasukan atau pengeluaran</p>
            </div>
            <div class="grid grid-cols-2 gap-4">
                <a href="input_masuk.php" class="flex flex-col items-center justify-center p-6 bg-emerald-50 rounded-[2rem] border border-emerald-100 active:scale-95 transition-all">
                    <div class="w-12 h-12 bg-emerald-500 rounded-2xl flex items-center justify-center text-white mb-3 shadow-lg shadow-emerald-500/20">
                        <i data-lucide="arrow-down-to-line" class="w-6 h-6"></i>
                    </div>
                    <span class="font-bold text-slate-800 text-sm">Masuk</span>
                </a>
                <a href="input_keluar.php" class="flex flex-col items-center justify-center p-6 bg-rose-50 rounded-[2rem] border border-rose-100 active:scale-95 transition-all">
                    <div class="w-12 h-12 bg-rose-500 rounded-2xl flex items-center justify-center text-white mb-3 shadow-lg shadow-rose-500/20">
                        <i data-lucide="arrow-up-from-line" class="w-6 h-6"></i>
                    </div>
                    <span class="font-bold text-slate-800 text-sm">Keluar</span>
                </a>
            </div>
        </div>
    </div>

    <script>
        lucide.createIcons();

        // Mobile Menu Toggle
        function toggleMobileMenu() {
            const backdrop = document.getElementById('mobileBackdrop');
            const content = document.getElementById('mobileMenuContent');
            const icon = document.getElementById('mobileMenuIcon');
            
            if (content.classList.contains('mobile-closed')) {
                backdrop.classList.remove('hidden');
                setTimeout(() => {
                    content.classList.remove('mobile-closed');
                    content.classList.add('mobile-open');
                    icon.style.transform = 'rotate(45deg)';
                }, 10);
            } else {
                content.classList.remove('mobile-open');
                content.classList.add('mobile-closed');
                icon.style.transform = 'rotate(0deg)';
                setTimeout(() => backdrop.classList.add('hidden'), 300);
            }
        }

        // Desktop Dropdown
        function toggleDesktopDropdown() {
            const menu = document.getElementById('desktopDropdownMenu');
            const chevron = document.getElementById('desktopChevron');
            if (menu.classList.contains('hidden')) {
                menu.classList.remove('hidden');
                setTimeout(() => chevron.style.transform = 'rotate(180deg)', 10);
            } else {
                menu.classList.add('hidden');
                chevron.style.transform = 'rotate(0deg)';
            }
        }

        // Close dropdown when clicking outside
        window.onclick = function(event) {
            if (!event.target.closest('#desktopDropdownBtn')) {
                const menu = document.getElementById('desktopDropdownMenu');
                const chevron = document.getElementById('desktopChevron');
                if (menu && !menu.classList.contains('hidden')) {
                    menu.classList.add('hidden');
                    chevron.style.transform = 'rotate(0deg)';
                }
            }
        }
    </script>
</body>
</html>