<?php
include '../config.php';
session_start();

// 1. Proteksi Halaman
if (!isset($_SESSION['username'])) {
    header("Location: ../login.php");
    exit;
}

// 2. Ambil Data Tampilan (DIPINDAH KE ATAS SEBELUM LOGIKA HAPUS)
$query = "SELECT * FROM data_jaitun ORDER BY tanggal DESC, id DESC";
$result = mysqli_query($conn, $query);

// 3. Logika Hapus Data & Revert Saldo (Pengirim & Penerima)
if (isset($_GET['hapus'])) {
    $id_hapus = mysqli_real_escape_string($conn, $_GET['hapus']);
    
    mysqli_begin_transaction($conn);

    try {
        // Ambil data yang mau dihapus
        $cek = mysqli_query($conn, "SELECT * FROM data_jaitun WHERE id = '$id_hapus'");
        $data = mysqli_fetch_assoc($cek);

        if ($data) {
            // --- 1. HITUNG NOMINAL TOTAL TRANSAKSI JAITUN ---
            // Menghitung komponen angka untuk mengetahui efek ke saldo Jaitun
            $nominal_transaksi = (float)$data['masuk'] + 
                                 (float)$data['transit_nominal'] + // Uang transit ikut dihitung
                                 (float)$data['jasa'] + 
                                 (float)$data['simpanan_wajib'] + 
                                 (float)$data['tata_usaha'] + 
                                 (float)$data['angsuran_pinjaman'] +
                                 (float)($data['pinjaman'] ?? 0) + 
                                 (float)($data['pinjaman_2025'] ?? 0);

            // Tentukan arah perubahan saldo Jaitun saat dihapus
            $perubahan_saldo = 0;
            if ($data['jenis_transaksi'] == 'Keluar') {
                // Hapus Keluar = Saldo Jaitun Bertambah (Kembali)
                $perubahan_saldo = -1 * $nominal_transaksi; 
            } else {
                // Hapus Masuk = Saldo Jaitun Berkurang
                // NOTE: Karena transit ada di form Masuk (mengurangi saldo akhir),
                // logika di bawah (update saldo_akhir) akan otomatis menyesuaikan.
                $perubahan_saldo = $nominal_transaksi;
            }

// --- [REVISI FIXED] HAPUS DATA DI PENERIMA (MARGIYANTO/MAULANA) ---
            $transit_via = $data['transit_via'];     // Ke siapa (Margiyanto/Maulana)
            $transit_nominal = (float)$data['transit_nominal'];
            $tanggal_hapus = $data['tanggal'];

            if (!empty($transit_via) && $transit_nominal > 0) {
                $tabel_target = "";
                if ($transit_via == 'Margiyanto') $tabel_target = "data_margiyanto";
                elseif ($transit_via == 'Maulana') $tabel_target = "data_maulana";

                if ($tabel_target != "") {
                    
                    // 1. UPDATE SALDO MASA DEPAN (Revert Balance)
                    // Kurangi saldo_awal & saldo_akhir untuk semua tanggal SETELAH tanggal dihapus
                    $query_update_future = "UPDATE $tabel_target 
                                            SET saldo_awal = saldo_awal - $transit_nominal,
                                                saldo_akhir = saldo_akhir - $transit_nominal
                                            WHERE tanggal > '$tanggal_hapus'";
                    mysqli_query($conn, $query_update_future);

                    // 2. HAPUS DATA HARI ITU
                    // Hapus baris di tanggal tersebut yang memiliki keterangan "Jaitun" atau "Transit"
                    // KITA HAPUS SYARAT 'saldo_akhir' AGAR PASTI KETEMU DAN KEHAPUS
                    
                    $query_hapus_target = "DELETE FROM $tabel_target 
                                           WHERE tanggal = '$tanggal_hapus' 
                                           AND (keterangan LIKE '%Jaitun%' OR keterangan LIKE '%Transit%')";
                                           
                    $hapus_target = mysqli_query($conn, $query_hapus_target);
                    
                    // Cek jika gagal hapus (opsional, untuk debugging)
                    if (mysqli_affected_rows($conn) == 0) {
                        // Jika ternyata tidak ada baris yang terhapus (misal karena keterangan beda),
                        // setidaknya kita kurangi saldonya (fallback mechanism)
                        $query_koreksi_saldo = "UPDATE $tabel_target 
                                                SET saldo_akhir = saldo_akhir - $transit_nominal
                                                WHERE tanggal = '$tanggal_hapus'";
                        mysqli_query($conn, $query_koreksi_saldo);
                    }
                }
            }


            // --- 3. REVERT SALDO KOPERASI (TABEL INDUK) ---
            $ket_target = $data['keterangan']; 
            
            // Cari data saldo koperasi yang sesuai tanggal dan keterangan
            $q_cari_kop = "SELECT id FROM saldo_koperasi 
                           WHERE tanggal = '$tanggal_hapus' 
                           AND (keterangan = '$ket_target' OR keterangan LIKE '%$ket_target%') 
                           LIMIT 1";
            $res_kop = mysqli_query($conn, $q_cari_kop);
            $data_kop = mysqli_fetch_assoc($res_kop);

            if ($data_kop) {
                $id_kop_hapus = $data_kop['id'];
                // Update semua saldo koperasi SETELAH transaksi ini
                $update_sisa_kop = "UPDATE saldo_koperasi 
                                    SET saldo_utama_akhir = saldo_utama_akhir - ($perubahan_saldo),
                                        saldo_utama = saldo_utama - ($perubahan_saldo)
                                    WHERE id > '$id_kop_hapus'";
                mysqli_query($conn, $update_sisa_kop);
                
                // Hapus data fisik di saldo koperasi
                mysqli_query($conn, "DELETE FROM saldo_koperasi WHERE id = '$id_kop_hapus'");
            }

            // --- 4. UPDATE SALDO JAITUN (Running Balance) ---
            $id_data_hapus = $data['id'];
            
            // Update Saldo Akhir baris-baris setelahnya
            $update_saldo_akhir = "UPDATE data_jaitun 
                                   SET saldo_akhir = saldo_akhir - ($perubahan_saldo)
                                   WHERE (tanggal > '$tanggal_hapus') 
                                   OR (tanggal = '$tanggal_hapus' AND id > $id_data_hapus)";
            mysqli_query($conn, $update_saldo_akhir);

            // Update Saldo Awal baris-baris setelahnya
            $update_saldo_awal = "UPDATE data_jaitun 
                                  SET saldo_awal = saldo_awal - ($perubahan_saldo)
                                  WHERE (tanggal > '$tanggal_hapus') 
                                  OR (tanggal = '$tanggal_hapus' AND id > $id_data_hapus)";
            mysqli_query($conn, $update_saldo_awal);

            // --- 5. HAPUS FISIK DATA JAITUN ---
            mysqli_query($conn, "DELETE FROM data_jaitun WHERE id = '$id_hapus'");

            mysqli_commit($conn);
            header("Location: ?status=deleted");
            exit;
        }
    } catch (Exception $e) {
        mysqli_rollback($conn);
        echo "<script>alert('Gagal menghapus: " . $e->getMessage() . "');</script>";
    }
}

// 4. Ambil Saldo Utama
$q_saldo_koperasi = mysqli_query($conn, "SELECT saldo_utama_akhir FROM saldo_koperasi ORDER BY id DESC LIMIT 1");
$res_saldo_koperasi = mysqli_fetch_assoc($q_saldo_koperasi);
$saldo_utama_koperasi = $res_saldo_koperasi['saldo_utama_akhir'] ?? 0;

// 5. Reset Pointer Result untuk digunakan lagi di mobile view
mysqli_data_seek($result, 0);

function formatRupiah($angka) {
    if ($angka == 0 || $angka == NULL) return '-';
    return 'Rp ' . number_format($angka, 0, ',', '.');
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Riwayat Transaksi - Jaitun</title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <script src="https://unpkg.com/lucide@latest"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; -webkit-tap-highlight-color: transparent; }
        .swal2-popup { border-radius: 2rem !important; font-family: 'Plus Jakarta Sans', sans-serif !important; }
        .custom-scroll::-webkit-scrollbar { height: 8px; }
        .custom-scroll::-webkit-scrollbar-track { background: #f1f5f9; }
        .custom-scroll::-webkit-scrollbar-thumb { background: #cbd5e1; border-radius: 4px; }
    </style>
</head>
<body class="bg-[#f8fafc] min-h-screen pb-20 md:pb-10">

    <header class="bg-white/80 backdrop-blur-md px-5 py-4 sticky top-0 z-40 border-b border-slate-200 flex items-center justify-between">
        <div class="flex items-center gap-4">
            <a href="jaitun_view.php" class="w-10 h-10 rounded-xl flex items-center justify-center text-slate-600 hover:bg-slate-100 transition-all border border-slate-100">
                <i data-lucide="arrow-left" class="w-5 h-5"></i>
            </a>
            <div>
                <h1 class="text-lg font-extrabold text-slate-900 tracking-tight">Riwayat Jaitun</h1>
                <p class="text-[10px] uppercase tracking-widest font-bold text-slate-400">Data Transaksi</p>
            </div>
        </div>
        <div class="flex gap-2">
            <a href="input_keluar.php" class="w-10 h-10 bg-rose-50 text-rose-600 rounded-xl flex items-center justify-center hover:bg-rose-100 transition-all">
                <i data-lucide="minus" class="w-5 h-5"></i>
            </a>
            <a href="input_masuk.php" class="w-10 h-10 bg-indigo-50 text-indigo-600 rounded-xl flex items-center justify-center hover:bg-indigo-100 transition-all">
                <i data-lucide="plus" class="w-5 h-5"></i>
            </a>
        </div>
    </header>

    <main class="max-w-[95%] mx-auto p-4 md:p-6">
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-3 mb-6">
            <div class="bg-white p-4 rounded-3xl border border-slate-100 shadow-sm">
                <p class="text-xs text-slate-500 font-medium">Total Riwayat</p>
                <p class="text-lg font-bold text-slate-800"><?= mysqli_num_rows($result) ?> <span class="text-xs font-normal text-slate-400">Baris</span></p>
            </div>
            
            <div class="bg-indigo-600 p-4 rounded-3xl shadow-lg shadow-indigo-100">
                <p class="text-xs text-indigo-100 font-medium">Saldo Utama Saat Ini</p>
                <p class="text-lg font-bold text-white"><?= formatRupiah($saldo_utama_koperasi) ?></p>
            </div>
            
            <div class="bg-white p-4 rounded-3xl border border-slate-100 shadow-sm">
                <p class="text-xs text-slate-500 font-medium">Update Terakhir</p>
                <p class="text-sm font-bold text-slate-800"><?= date('d M Y') ?></p>
            </div>
        </div>

        <div class="bg-white rounded-[2rem] shadow-sm border border-slate-200 overflow-hidden">
            
            <div class="hidden md:block overflow-x-auto custom-scroll">
                <table class="w-full text-sm text-left whitespace-nowrap">
                    <thead class="text-[11px] text-slate-500 uppercase tracking-wider bg-slate-50/50 border-b border-slate-100">
                        <tr>
                            <th class="px-6 py-5 font-bold sticky left-0 bg-slate-50 z-20 border-r border-slate-200 shadow-sm">Tanggal</th>
                            <th class="px-4 py-5 font-bold">Saldo Awal</th>
                            
                            <th class="px-4 py-5 font-bold text-emerald-600">Masuk</th>
                            
                            <th class="px-4 py-5 font-bold text-rose-600">Keluar / Pinj.</th>
                            
                            <th class="px-4 py-5 font-bold text-orange-600 bg-orange-50/20">Jasa</th>
                            <th class="px-4 py-5 font-bold text-orange-600 bg-orange-50/20">SW</th>
                            <th class="px-4 py-5 font-bold text-orange-600 bg-orange-50/20">TU</th>
                            <th class="px-4 py-5 font-bold text-orange-600 bg-orange-50/20">Angsuran</th>
                            <th class="px-4 py-5 font-bold text-orange-600 bg-orange-50/20">Tertahan</th>
                            <th class="px-4 py-5 font-bold bg-indigo-50 text-indigo-700">Saldo Utama</th>
                            <th class="px-4 py-5 font-bold bg-blue-50 text-blue-700">Saldo Akhir</th>
                            <th class="px-6 py-5 font-bold">Keterangan</th>
                            <th class="px-6 py-5 font-bold text-center sticky right-0 bg-slate-50 z-20 border-l border-slate-200">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-50">
                        <?php if(mysqli_num_rows($result) > 0): ?>
                            <?php while($row = mysqli_fetch_assoc($result)): 
                                // Cek status
                                $isKeluar = ($row['jenis_transaksi'] == 'Keluar'); 
                            ?>
                            <tr class="hover:bg-slate-50/80 transition-colors group">
                                <td class="px-6 py-4 sticky left-0 bg-white group-hover:bg-slate-50 z-20 border-r border-slate-100 font-semibold text-slate-700">
                                    <?= date('d/m/Y', strtotime($row['tanggal'])) ?>
                                </td>
                                <td class="px-4 py-4 text-slate-500"><?= formatRupiah($row['saldo_awal']) ?></td>
                                
                                <td class="px-4 py-4">
                                    <?php 
                                    // Tampilkan di MASUK hanya jika BUKAN 'Keluar' dan punya nilai masuk
                                    if($row['masuk'] > 0): ?>
                                        <span class="text-emerald-600 font-bold"><?= formatRupiah($row['masuk']) ?></span>
                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>

                                <td class="px-4 py-4 text-rose-600 font-bold">
                                    <?php 
                                    // Total Pengeluaran = Pinjaman + (Transit jika ini transaksi Input Masuk/Transit Keluar) + Pengeluaran Harian
                                    // Karena di Input Masuk, transit mengurangi saldo, kita tampilkan di kolom Keluar agar balance secara visual
                                    $total_keluar_row = (float)$row['pinjaman_2025'];
                                    
                                    // Jika ada transit nominal, tampilkan sebagai pengeluaran (karena mengurangi saldo akhir Jaitun)
                                    if ($row['transit_nominal'] > 0) {
                                        $total_keluar_row += (float)$row['transit_nominal'];
                                    }
                                    
                                    echo ($total_keluar_row > 0) ? formatRupiah($total_keluar_row) : '-';
                                    ?>
                                </td>

                                <td class="px-4 py-4 text-orange-600 bg-orange-50/10"><?= formatRupiah($row['jasa']) ?></td>
                                <td class="px-4 py-4 text-orange-600 bg-orange-50/10"><?= formatRupiah($row['simpanan_wajib']) ?></td>
                                <td class="px-4 py-4 text-orange-600 bg-orange-50/10"><?= formatRupiah($row['tata_usaha']) ?></td>
                                <td class="px-4 py-4 text-orange-600 bg-orange-50/10"><?= formatRupiah($row['angsuran_pinjaman']) ?></td>
                                <td class="px-4 py-4 text-slate-500 bg-orange-50/10"><?= formatRupiah($row['pinjaman_tertahan']) ?></td>
                                <td class="px-4 py-4 font-bold text-indigo-700 bg-indigo-50/10">
                                    <?= formatRupiah($row['saldo_akhir']) ?>
                                </td>
                                <td class="px-4 py-4 font-bold text-blue-700 bg-blue-50/10">
                                    <?= formatRupiah($row['saldo_akhir']) ?>
                                </td>
                                <td class="px-6 py-4 text-slate-600 text-xs italic truncate max-w-[150px]">
                                    <?php 
                                        echo $row['keterangan'] ?: '-';
                                        if($row['transit_nominal'] > 0) {
                                            echo " <span class='text-orange-500 font-bold'>(Ke: {$row['transit_via']})</span>";
                                        }
                                    ?>
                                </td>
                                <td class="px-6 py-4 text-center sticky right-0 bg-white group-hover:bg-slate-50 z-20 border-l border-slate-100">
                                    <button onclick="confirmDelete(<?= $row['id'] ?>, '<?= $row['jenis_transaksi'] ?>', '<?= $row['transit_via'] ?>')" class="p-2 text-rose-500 hover:bg-rose-50 rounded-lg transition-all">
                                        <i data-lucide="trash-2" class="w-4 h-4"></i>
                                    </button>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr><td colspan="13" class="p-20 text-center text-slate-400">Belum ada data transaksi</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- Versi Mobile - Lebih Detail -->
            <div class="md:hidden">
                <?php 
                mysqli_data_seek($result, 0); 
                while($row = mysqli_fetch_assoc($result)): 
                    $isKeluar = ($row['jenis_transaksi'] == 'Keluar');
                    $hasTransit = $row['transit_nominal'] > 0;
                    $totalKeluar = (float)$row['pinjaman_2025'] + ($hasTransit ? (float)$row['transit_nominal'] : 0);
                ?>
                <div class="border-b border-slate-100 last:border-b-0">
                    <!-- Header Card -->
                    <div class="bg-gradient-to-r from-slate-50 to-white px-5 py-4 border-b border-slate-100">
                        <div class="flex justify-between items-center">
                            <div>
                                <span class="text-[11px] font-bold text-slate-500 uppercase bg-slate-100 px-2 py-1 rounded-md inline-block">
                                    <?= date('d M Y', strtotime($row['tanggal'])) ?>
                                </span>
                                <?php if($isKeluar): ?>
                                    <span class="text-[9px] bg-rose-100 text-rose-600 px-2 py-0.5 rounded ml-1 font-bold">KELUAR</span>
                                <?php else: ?>
                                    <span class="text-[9px] bg-emerald-100 text-emerald-600 px-2 py-0.5 rounded ml-1 font-bold">MASUK</span>
                                <?php endif; ?>
                            </div>
                            <button onclick="confirmDelete(<?= $row['id'] ?>, '<?= $row['jenis_transaksi'] ?>', '<?= $row['transit_via'] ?>')" class="p-2 bg-white text-rose-400 border border-slate-100 rounded-full shadow-sm hover:bg-rose-50 transition-all">
                                <i data-lucide="trash-2" class="w-4 h-4"></i>
                            </button>
                        </div>
                        
                        <?php if($row['keterangan']): ?>
                            <p class="text-sm font-bold text-slate-800 mt-2"><?= $row['keterangan'] ?></p>
                        <?php endif; ?>
                        
                        <?php if($hasTransit): ?>
                            <div class="mt-2 flex items-center text-orange-600 text-xs font-semibold">
                                <i data-lucide="arrow-right" class="w-3 h-3 mr-1"></i>
                                <span>Kirim ke: <?= $row['transit_via'] ?></span>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Detail Transaksi -->
                    <div class="p-4 space-y-3">
                        <!-- Saldo Awal -->
                        <div class="flex justify-between items-center p-3 bg-slate-50 rounded-lg">
                            <span class="text-xs text-slate-500">Saldo Awal</span>
                            <span class="text-sm font-bold text-slate-700"><?= formatRupiah($row['saldo_awal']) ?></span>
                        </div>

                        <!-- Uang Masuk -->
                        <?php if($row['masuk'] > 0): ?>
                        <div class="flex justify-between items-center p-3 bg-emerald-50 rounded-lg border border-emerald-100">
                            <span class="text-xs text-emerald-600 font-semibold">Uang Masuk</span>
                            <span class="text-sm font-bold text-emerald-700">+<?= formatRupiah($row['masuk']) ?></span>
                        </div>
                        <?php endif; ?>

                        <!-- Uang Keluar -->
                        <?php if($totalKeluar > 0): ?>
                        <div class="flex justify-between items-center p-3 bg-rose-50 rounded-lg border border-rose-100">
                            <div>
                                <span class="text-xs text-rose-600 font-semibold">Uang Keluar</span>
                                <?php if($row['pinjaman_2025'] > 0): ?>
                                    <div class="text-[10px] text-rose-500 mt-1">Pinjaman: <?= formatRupiah($row['pinjaman_2025']) ?></div>
                                <?php endif; ?>
                                <?php if($hasTransit): ?>
                                    <div class="text-[10px] text-rose-500 mt-1">Transit: <?= formatRupiah($row['transit_nominal']) ?></div>
                                <?php endif; ?>
                            </div>
                            <span class="text-sm font-bold text-rose-700">-<?= formatRupiah($totalKeluar) ?></span>
                        </div>
                        <?php endif; ?>

                        <!-- Detail Potongan -->
                        <div class="grid grid-cols-2 gap-2">
                            <?php if($row['jasa'] > 0): ?>
                            <div class="flex justify-between items-center p-2 bg-orange-50 rounded-lg border border-orange-100">
                                <span class="text-[10px] text-orange-600">Jasa</span>
                                <span class="text-xs font-bold text-orange-700"><?= formatRupiah($row['jasa']) ?></span>
                            </div>
                            <?php endif; ?>

                            <?php if($row['simpanan_wajib'] > 0): ?>
                            <div class="flex justify-between items-center p-2 bg-orange-50 rounded-lg border border-orange-100">
                                <span class="text-[10px] text-orange-600">SW</span>
                                <span class="text-xs font-bold text-orange-700"><?= formatRupiah($row['simpanan_wajib']) ?></span>
                            </div>
                            <?php endif; ?>

                            <?php if($row['tata_usaha'] > 0): ?>
                            <div class="flex justify-between items-center p-2 bg-orange-50 rounded-lg border border-orange-100">
                                <span class="text-[10px] text-orange-600">TU</span>
                                <span class="text-xs font-bold text-orange-700"><?= formatRupiah($row['tata_usaha']) ?></span>
                            </div>
                            <?php endif; ?>

                            <?php if($row['angsuran_pinjaman'] > 0): ?>
                            <div class="flex justify-between items-center p-2 bg-orange-50 rounded-lg border border-orange-100">
                                <span class="text-[10px] text-orange-600">Angsuran</span>
                                <span class="text-xs font-bold text-orange-700"><?= formatRupiah($row['angsuran_pinjaman']) ?></span>
                            </div>
                            <?php endif; ?>

                            <?php if($row['pinjaman_tertahan'] > 0): ?>
                            <div class="col-span-2 flex justify-between items-center p-2 bg-orange-50 rounded-lg border border-orange-100">
                                <span class="text-[10px] text-orange-600">Pinjaman Tertahan</span>
                                <span class="text-xs font-bold text-orange-700"><?= formatRupiah($row['pinjaman_tertahan']) ?></span>
                            </div>
                            <?php endif; ?>
                        </div>

                        <!-- Saldo Akhir -->
                        <div class="flex justify-between items-center p-4 bg-indigo-50 rounded-xl border border-indigo-200">
                            <div>
                                <p class="text-[10px] text-indigo-500 uppercase font-extrabold">Saldo Akhir</p>
                                <p class="text-[9px] text-indigo-400 mt-1">Saldo Utama Koperasi</p>
                            </div>
                            <p class="text-base font-bold text-indigo-600"><?= formatRupiah($row['saldo_akhir']) ?></p>
                        </div>
                    </div>
                </div>
                <?php endwhile; ?>
                
                <?php if(mysqli_num_rows($result) == 0): ?>
                <div class="p-12 text-center text-slate-400">
                    <p class="text-lg font-semibold">Belum ada data transaksi</p>
                    <p class="text-sm mt-2">Silakan tambahkan transaksi baru</p>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </main>

    <script>
        lucide.createIcons();

        function confirmDelete(id, jenisTransaksi, transitVia) {
            let warningText = "Saldo Jaitun akan dikembalikan otomatis.";
            
            if (transitVia && transitVia !== '') {
                warningText += `\nSaldo ${transitVia} juga akan DIKURANGI otomatis.`;
            }

            Swal.fire({
                title: 'Hapus Transaksi?',
                text: warningText,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#ef4444',
                cancelButtonColor: '#64748b',
                confirmButtonText: 'Ya, Hapus & Revert!',
                cancelButtonText: 'Batal',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "?hapus=" + id;
                }
            })
        }

        const params = new URLSearchParams(window.location.search);
        if (params.get('status') === 'deleted') {
            Swal.fire({
                icon: 'success',
                title: 'Dihapus!',
                text: 'Data dihapus dan semua saldo terkait telah dikembalikan.',
                showConfirmButton: false,
                timer: 2000
            });
            window.history.replaceState({}, document.title, window.location.pathname);
        }
    </script>
</body>
</html>