<?php
include 'config.php';
session_start();

// 1. CEK SESSION (Auto-Redirect)
if (isset($_SESSION['role'])) {
    if ($_SESSION['role'] == 'admin') {
        header("Location: admin/admin_dashboard.php");
    } elseif ($_SESSION['username'] == 'jaitun') {
        header("Location: jaitun/jaitun_view.php");
    } elseif ($_SESSION['username'] == 'margiyanto') {
        header("Location: margiyanto/margiyanto_view.php");
    } elseif ($_SESSION['username'] == 'maulana') {
        header("Location: maulana/index.php");
    }
    exit;
}

$error = "";

// 2. PROSES LOGIN
if (isset($_POST['login'])) {
    $username = mysqli_real_escape_string($conn, $_POST['username']);
    $password = $_POST['password'];

    $query = "SELECT * FROM users WHERE username = '$username'";
    $result = mysqli_query($conn, $query);

    if (mysqli_num_rows($result) === 1) {
        $row = mysqli_fetch_assoc($result);
        
        // Perbandingan password (Catatan: Sebaiknya gunakan password_verify di produksi)
        if ($password === $row['password']) {
            $_SESSION['username'] = $row['username'];
            $_SESSION['role']     = $row['role'];
            $_SESSION['nama']     = $row['nama_lengkap'];

            if ($row['role'] == 'admin') {
                header("Location: admin/admin_dashboard.php");
            } elseif ($row['username'] == 'jaitun') {
                header("Location: jaitun/jaitun_view.php");
            } elseif ($row['username'] == 'margiyanto') {
                header("Location: margiyanto/margiyanto_view.php");
            } elseif ($row['username'] == 'maulana') {
                header("Location: maulana/index.php");
            }
            exit;
        } else {
            $error = "Password yang Anda masukkan salah.";
        }
    } else {
        $error = "Username tidak terdaftar dalam sistem.";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login System</title>
    
    <link rel="icon" href="icon.png" type="image/png">
    
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <script src="https://cdn.tailwindcss.com"></script>
    
    <script src="https://unpkg.com/lucide@latest"></script>

    <style>
        body { font-family: 'Inter', sans-serif; }
    </style>
</head>
<body class="bg-gray-50">

    <div class="min-h-screen flex">
        
<div class="hidden lg:flex w-1/2 bg-emerald-900 relative justify-center items-center overflow-hidden">
    <div class="absolute inset-0 opacity-20">
        <img src="https://images.unsplash.com/photo-1582213782179-e0d53f98f2ca?ixlib=rb-1.2.1&auto=format&fit=crop&w=1950&q=80" 
             class="w-full h-full object-cover" alt="Background Cooperative Teamwork">
    </div>
    
    <div class="relative z-10 p-12 text-white max-w-lg text-center">
        <div class="mb-6 flex justify-center">
            <div class="bg-white/10 p-4 rounded-full backdrop-blur-sm border border-white/20">
                <i data-lucide="users" class="w-12 h-12 text-white"></i>
            </div>
        </div>
        <h2 class="text-4xl font-bold mb-4 tracking-tight">Koperasi Mandiri</h2>
        <p class="text-emerald-100 text-lg leading-relaxed">
            Dari anggota untuk anggota. Sistem manajemen terintegrasi untuk transparansi dan kesejahteraan bersama.
        </p>
        
        <div class="mt-12 flex justify-center space-x-2">
            <span class="w-2 h-2 bg-white rounded-full"></span>
            <span class="w-2 h-2 bg-white/50 rounded-full"></span>
            <span class="w-2 h-2 bg-white/50 rounded-full"></span>
        </div>
    </div>
</div>

        <div class="w-full lg:w-1/2 flex items-center justify-center p-6 lg:p-12 bg-white">
            <div class="w-full max-w-md">
                
                <div class="text-center lg:hidden mb-8">
                    <img src="icon.png" alt="Logo" class="mx-auto h-16 w-auto mb-3">
                    <h2 class="text-2xl font-bold text-gray-900">Koperasi Mandiri</h2>
                </div>

                <div class="mb-8">
                    <h1 class="text-3xl font-bold text-gray-900 mb-2">Selamat Datang</h1>
                    <p class="text-gray-500">Silakan masukkan kredensial Anda untuk mengakses sistem.</p>
                </div>

                <?php if($error != ""): ?>
                <div class="flex items-center p-4 mb-6 text-sm text-red-800 border border-red-200 rounded-lg bg-red-50" role="alert">
                    <i data-lucide="alert-circle" class="flex-shrink-0 inline w-5 h-5 mr-3"></i>
                    <span class="font-medium"><?php echo $error; ?></span>
                </div>
                <?php endif; ?>

                <form action="" method="POST" class="space-y-6">
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Username</label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <i data-lucide="user" class="h-5 w-5 text-gray-400"></i>
                            </div>
                            <input type="text" name="username" required autofocus
                                class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-600 focus:border-transparent outline-none transition-all text-gray-900 placeholder-gray-400 bg-gray-50 focus:bg-white"
                                placeholder="Contoh: admin">
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Password</label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <i data-lucide="lock" class="h-5 w-5 text-gray-400"></i>
                            </div>
                            <input type="password" name="password" id="passwordInput" required
                                class="w-full pl-10 pr-12 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-600 focus:border-transparent outline-none transition-all text-gray-900 placeholder-gray-400 bg-gray-50 focus:bg-white"
                                placeholder="••••••••">
                            
                            <button type="button" onclick="togglePassword()"
                                class="absolute inset-y-0 right-0 pr-3 flex items-center text-gray-400 hover:text-blue-600 cursor-pointer focus:outline-none transition-colors">
                                <i data-lucide="eye" id="iconShow" class="h-5 w-5"></i>
                                <i data-lucide="eye-off" id="iconHide" class="h-5 w-5 hidden"></i>
                            </button>
                        </div>
                    </div>

                    <button type="submit" name="login"
                        class="w-full flex justify-center py-3 px-4 border border-transparent rounded-lg shadow-sm text-sm font-bold text-white bg-blue-700 hover:bg-blue-800 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-600 transition-all transform active:scale-95">
                        MASUK
                    </button>
                </form>

                <div class="mt-8 text-center">
                    <p class="text-xs text-gray-400">
                        &copy; 2026 Koperasi Mandiri. All rights reserved.<br>
                        Sistem Versi 1.0
                    </p>
                </div>

            </div>
        </div>
    </div>

    <script>
        // Render Icons
        lucide.createIcons();

        function togglePassword() {
            const passwordInput = document.getElementById('passwordInput');
            const iconShow = document.getElementById('iconShow'); // Ini akan menjadi SVG setelah render
            const iconHide = document.getElementById('iconHide'); // Ini akan menjadi SVG setelah render

            // Karena lucide merender SVG menggantikan tag <i>, kita manipulasi class parent atau display style
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                // Manual handling untuk SVG lucide (karena element berubah jadi SVG)
                // Cara paling aman dengan Lucide inline: toggle class hidden pada element yang tepat
                // Di sini kita toggle class hidden pada elemen SVG yang dihasilkan
                document.querySelector('[data-lucide="eye"]').classList.add('hidden');
                document.querySelector('[data-lucide="eye-off"]').classList.remove('hidden');
            } else {
                passwordInput.type = 'password';
                document.querySelector('[data-lucide="eye"]').classList.remove('hidden');
                document.querySelector('[data-lucide="eye-off"]').classList.add('hidden');
            }
        }
    </script>

</body>
</html>