<?php
include '../config.php';
session_start();

// 1. Proteksi Halaman
if (!isset($_SESSION['username']) || ($_SESSION['username'] !== 'margiyanto' && $_SESSION['role'] !== 'admin')) {
    header("Location: ../login.php");
    exit;
}

$message = "";
$msg_type = "";

// --- LANGKAH 1: AMBIL DATA SALDO TERAKHIR DARI KEDUA TABEL ---

// A. Ambil Saldo Global (Tabel: saldo_koperasi)
$q_global = mysqli_query($conn, "SELECT saldo_utama_akhir FROM saldo_koperasi ORDER BY id DESC LIMIT 1");
$d_global = mysqli_fetch_assoc($q_global);
$saldo_global_lama = $d_global ? $d_global['saldo_utama_akhir'] : 0;

// B. Ambil Saldo Detail (Tabel: data_margiyanto)
$q_margiyanto = mysqli_query($conn, "SELECT saldo_akhir FROM data_margiyanto ORDER BY tanggal DESC, id DESC LIMIT 1");
$d_margiyanto = mysqli_fetch_assoc($q_margiyanto);
$saldo_margiyanto_lama = $d_margiyanto ? $d_margiyanto['saldo_akhir'] : 0;


// 2. Proses Form Submit
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $tanggal = $_POST['tanggal'];
    $kategori = $_POST['keterangan']; // Dropdown
    
    // Ambil nominal & hilangkan titik
    $nominal = str_replace('.', '', $_POST['nominal_keluar']);
    if($nominal == "") $nominal = 0;

    if (empty($tanggal) || empty($nominal) || $nominal <= 0) {
        $message = "Tanggal dan Nominal wajib diisi dengan benar!";
        $msg_type = "error";
    } else {
        
        // --- LOGIKA MAPPING SESUAI STRUKTUR DATABASE ---
        // Sesuai kolom di tabel data_margiyanto:
        // simpanan_wajib, jasa, keluar, transit_nominal, angsuran_pinjaman
        
        $col_sw = 0; 
        $col_jasa = 0; 
        $col_keluar = 0; 
        $col_transit = 0;
        $col_angsuran = 0;

        if ($kategori == 'Simpanan Wajib') {
            $col_sw = $nominal;
        } elseif ($kategori == 'Jasa') {
            $col_jasa = $nominal;
        } elseif ($kategori == 'Pinjaman') {
            $col_angsuran = $nominal; // Masuk ke angsuran_pinjaman
        } elseif ($kategori == 'Operasional') {
            $col_transit = $nominal; // Operasional masuk transit
        } else {
            $col_keluar = $nominal; // Lainnya masuk kolom keluar
        }

        // --- HITUNG MATEMATIKA (PENGURANGAN) ---
        $saldo_global_baru = $saldo_global_lama - $nominal;
        $saldo_margiyanto_baru = $saldo_margiyanto_lama - $nominal;
        
        // Buat Keterangan String
        $ket_fix = "Keluar: " . $kategori;

        // --- QUERY KE TABEL saldo_koperasi ---
        $sql1 = "INSERT INTO saldo_koperasi 
                 (tanggal, saldo_utama, saldo_utama_akhir, keterangan) 
                 VALUES 
                 ('$tanggal', '$saldo_global_lama', '$saldo_global_baru', '$ket_fix')";

        // --- QUERY KE TABEL data_margiyanto ---
        // HANYA gunakan kolom yang ADA di database
        $sql2 = "INSERT INTO data_margiyanto 
                 (tanggal, keterangan, simpanan_wajib, jasa, keluar, transit_nominal, angsuran_pinjaman, saldo_awal, saldo_akhir) 
                 VALUES 
                 ('$tanggal', '$kategori', '$col_sw', '$col_jasa', '$col_keluar', '$col_transit', '$col_angsuran', '$saldo_margiyanto_lama', '$saldo_margiyanto_baru')";

        // Jalankan Query
        $simpan1 = mysqli_query($conn, $sql1);
        $simpan2 = mysqli_query($conn, $sql2);

        if ($simpan1 && $simpan2) {
            $message = "success";
            $msg_type = "success";
            
            // Update tampilan di layar agar langsung berubah
            $tampil_saldo_margiyanto = $saldo_margiyanto_baru;
            $tampil_saldo_global = $saldo_global_baru;
        } else {
            $error1 = mysqli_error($conn);
            $message = "Gagal menyimpan. Error: " . $error1;
            $msg_type = "error";
            $tampil_saldo_margiyanto = $saldo_margiyanto_lama;
            $tampil_saldo_global = $saldo_global_lama;
        }
    }
} else {
    // Tampilan awal
    $tampil_saldo_margiyanto = $saldo_margiyanto_lama;
    $tampil_saldo_global = $saldo_global_lama;
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Input Transaksi Keluar - Margiyanto</title>
    <link rel="icon" href="../icon.png" type="image/png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest"></script>
    <!-- SweetAlert2 -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; -webkit-tap-highlight-color: transparent; }
        .card-glow { box-shadow: 0 0 20px rgba(185, 28, 28, 0.3); }
        .input-focus { transition: all 0.3s ease; }
        .input-focus:focus { box-shadow: 0 0 0 3px rgba(185, 28, 28, 0.2); }
        @keyframes pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.5; }
        }
        .pulse { animation: pulse 2s cubic-bezier(0.4, 0, 0.6, 1) infinite; }
        .select-custom {
            appearance: none;
            background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' viewBox='0 0 24 24' fill='none' stroke='%2394a3b8' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'%3E%3Cpolyline points='6 9 12 15 18 9'%3E%3C/polyline%3E%3C/svg%3E");
            background-repeat: no-repeat;
            background-position: right 1rem center;
            background-size: 1rem;
        }
    </style>
</head>
<body class="bg-gradient-to-br from-red-50 to-rose-50 min-h-screen pb-10">

    <nav class="bg-gradient-to-r from-red-900 to-rose-900 text-white shadow-lg p-4 sticky top-0 z-50 border-b border-red-800/50">
        <div class="max-w-xl mx-auto flex justify-between items-center">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-gradient-to-br from-red-500 to-rose-600 rounded-xl flex items-center justify-center font-bold shadow-lg shadow-red-500/30">
                    <i data-lucide="arrow-up-right" class="w-6 h-6"></i>
                </div>
                <div>
                    <h1 class="font-bold text-lg leading-tight">Uang Keluar</h1>
                    <p class="text-[10px] text-red-200 uppercase tracking-widest font-bold flex items-center gap-1">
                        <i data-lucide="user" class="w-3 h-3"></i>
                        Margiyanto
                    </p>
                </div>
            </div>
            <a href="margiyanto_view.php" class="w-8 h-8 flex items-center justify-center bg-white/10 rounded-full hover:bg-white/20 transition-all active:scale-90">
                <i data-lucide="x" class="w-4 h-4"></i>
            </a>
        </div>
    </nav>

    <main class="max-w-xl mx-auto p-5">
        <!-- Card Saldo Info -->
        <div class="mb-5 grid grid-cols-1 gap-4">
            <div class="bg-gradient-to-br from-blue-600 to-cyan-700 rounded-2xl p-5 text-white shadow-lg card-glow border border-blue-800/50">
                <div class="flex items-center justify-between mb-3">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-blue-500/30 rounded-xl flex items-center justify-center">
                            <i data-lucide="building-2" class="w-5 h-5"></i>
                        </div>
                        <p class="text-blue-100 text-xs font-bold uppercase tracking-wider">Saldo Koperasi</p>
                    </div>
                    <span class="px-3 py-1 bg-blue-500/20 text-blue-200 text-xs font-bold rounded-full">
                        <i data-lucide="database" class="w-3 h-3 inline mr-1"></i>
                        Global
                    </span>
                </div>
                <h3 class="text-2xl font-bold mb-1">Rp <?= number_format($tampil_saldo_global, 0, ',', '.') ?></h3>
                <p class="text-blue-100 text-xs">Saldo keseluruhan koperasi</p>
            </div>

            <div class="bg-white p-5 rounded-2xl shadow-sm border border-slate-100">
                <div class="flex items-center justify-between mb-3">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-red-100 rounded-xl flex items-center justify-center text-red-600">
                            <i data-lucide="wallet" class="w-5 h-5"></i>
                        </div>
                        <p class="text-slate-400 text-xs font-bold uppercase tracking-wider">Saldo Margiyanto</p>
                    </div>
                    <span class="px-3 py-1 bg-red-50 text-red-700 text-xs font-bold rounded-full">
                        <i data-lucide="user" class="w-3 h-3 inline mr-1"></i>
                        Personal
                    </span>
                </div>
                <h3 class="text-2xl font-bold text-slate-800 mb-1">Rp <?= number_format($tampil_saldo_margiyanto, 0, ',', '.') ?></h3>
                <p class="text-slate-500 text-xs">Saldo pribadi Anda</p>
            </div>
        </div>

        <form action="" method="POST" class="space-y-5" id="transactionForm">
            <div class="bg-white p-5 rounded-2xl shadow-sm border border-slate-100 space-y-4">
                <div>
                    <label class="block text-xs font-bold text-slate-400 uppercase tracking-wider mb-2 flex items-center gap-2">
                        <i data-lucide="calendar" class="w-3 h-3"></i>
                        Tanggal Transaksi
                    </label>
                    <input type="date" name="tanggal" required value="<?= date('Y-m-d') ?>" class="w-full bg-slate-50 border border-slate-200 text-slate-800 text-sm rounded-xl focus:ring-2 focus:ring-red-500 block p-3 font-bold outline-none input-focus">
                </div>
            </div>

            <div class="bg-white p-5 rounded-2xl shadow-sm border border-slate-100 space-y-4">
                <h3 class="font-bold text-slate-800 border-b border-slate-100 pb-2 mb-2 flex items-center gap-2">
                    <i data-lucide="list" class="w-5 h-5 text-red-600"></i>
                    Rincian Pengeluaran
                </h3>
                
                <div>
                    <label class="block text-xs font-bold text-slate-500 mb-1 flex items-center gap-2">
                        <i data-lucide="tag" class="w-4 h-4 text-slate-400"></i>
                        Keperluan / Kategori
                    </label>
                    <div class="relative">
                        <select name="keterangan" id="keteranganSelect" onchange="cekJenis()" required class="w-full bg-slate-50 border border-slate-200 text-slate-800 rounded-xl focus:ring-2 focus:ring-red-500 block p-3 font-bold outline-none select-custom input-focus">
                            <option value="Operasional">Biaya Operasional (Listrik/Air/ATK)</option>
                            <option value="Simpanan Wajib">Pengembalian Simpanan Wajib</option>
                            <option value="Jasa">Pembagian Jasa / SHU</option>
                            <option value="Pinjaman">Pencairan Pinjaman Anggota</option>
                            <option value="Lainnya">Lainnya</option>
                        </select>
                    </div>
                    <p id="infoText" class="text-[10px] mt-2 italic text-slate-400"></p>
                </div>

                <div>
                    <label class="block text-xs font-bold text-slate-600 mb-1 flex items-center gap-2">
                        <i data-lucide="dollar-sign" class="w-4 h-4 text-slate-400"></i>
                        Nominal Keluar (Rp)
                    </label>
                    <div class="relative">
                        <span class="absolute left-4 top-3.5 text-slate-400 font-bold text-sm">
                            <i data-lucide="indian-rupee" class="w-4 h-4"></i>
                        </span>
                        <input type="text" name="nominal_keluar" required placeholder="0" onkeyup="formatRupiah(this)" class="w-full bg-red-50 border border-red-200 text-red-900 rounded-xl focus:ring-2 focus:ring-red-500 block p-3 pl-10 font-bold outline-none text-lg input-focus">
                    </div>
                </div>
            </div>

            <button type="submit" class="w-full bg-gradient-to-r from-red-600 to-rose-700 hover:from-red-700 hover:to-rose-800 text-white font-bold rounded-xl text-sm px-5 py-4 shadow-xl shadow-red-500/30 flex justify-center items-center gap-2 transition-all active:scale-95">
                <i data-lucide="paper-plane" class="w-5 h-5"></i>
                <span>Simpan Transaksi</span>
            </button>
        </form>
    </main>

    <!-- SweetAlert2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <script>
        // Initialize Lucide Icons
        lucide.createIcons();

        function formatRupiah(input) {
            let value = input.value.replace(/\D/g, "");
            value = new Intl.NumberFormat('id-ID').format(value);
            input.value = value === '0' ? '' : value;
        }

        function cekJenis() {
            var select = document.getElementById("keteranganSelect");
            var info = document.getElementById("infoText");
            var val = select.value;

            if (val === 'Pinjaman') {
                info.innerHTML = "<i data-lucide='alert-triangle' class='w-3 h-3 inline mr-1'></i> Masuk ke kolom angsuran_pinjaman.";
                info.className = "text-[10px] mt-2 italic p-2 bg-red-50 text-red-700 rounded border border-red-100";
                lucide.createIcons();
            } else if (val === 'Operasional') {
                info.innerHTML = "<i data-lucide='info' class='w-3 h-3 inline mr-1'></i> Masuk ke kolom transit_nominal.";
                info.className = "text-[10px] mt-2 italic text-slate-400";
                lucide.createIcons();
            } else if (val === 'Jasa') {
                info.innerHTML = "<i data-lucide='info' class='w-3 h-3 inline mr-1'></i> Masuk ke kolom jasa.";
                info.className = "text-[10px] mt-2 italic text-slate-400";
                lucide.createIcons();
            } else if (val === 'Simpanan Wajib') {
                info.innerHTML = "<i data-lucide='info' class='w-3 h-3 inline mr-1'></i> Masuk ke kolom simpanan_wajib.";
                info.className = "text-[10px] mt-2 italic text-slate-400";
                lucide.createIcons();
            } else {
                info.innerHTML = "<i data-lucide='info' class='w-3 h-3 inline mr-1'></i> Masuk ke kolom keluar.";
                info.className = "text-[10px] mt-2 italic text-slate-400";
                lucide.createIcons();
            }
        }
        cekJenis();

        // Handle form submission with SweetAlert2
        document.getElementById('transactionForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            // Get form values
            const tanggal = this.tanggal.value;
            const kategori = this.keterangan.value;
            const nominal = this.nominal_keluar.value.replace(/\D/g, '');
            
            if (!tanggal || !nominal || nominal <= 0) {
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: 'Tanggal dan Nominal wajib diisi dengan benar!',
                    confirmButtonColor: '#dc2626'
                });
                return;
            }

            // Format Rupiah untuk tampilan
            const formatRupiah = (angka) => {
                return new Intl.NumberFormat('id-ID').format(angka);
            };

            // Icon berdasarkan kategori
            let iconHtml = '';
            if (kategori === 'Pinjaman') {
                iconHtml = '<i data-lucide="credit-card" class="w-5 h-5 text-blue-500"></i>';
            } else if (kategori === 'Jasa') {
                iconHtml = '<i data-lucide="percent" class="w-5 h-5 text-green-500"></i>';
            } else if (kategori === 'Simpanan Wajib') {
                iconHtml = '<i data-lucide="piggy-bank" class="w-5 h-5 text-purple-500"></i>';
            } else {
                iconHtml = '<i data-lucide="shopping-cart" class="w-5 h-5 text-red-500"></i>';
            }

            // Show confirmation dialog
            Swal.fire({
                title: 'Konfirmasi Transaksi',
                html: `
                    <div class="text-left text-sm">
                        <div class="flex items-center gap-3 mb-4 p-3 bg-red-50 rounded-lg border border-red-200">
                            ${iconHtml}
                            <div>
                                <p class="font-bold text-red-700">${kategori}</p>
                                <p class="text-xs text-red-600">Pengeluaran Dana</p>
                            </div>
                        </div>
                        <div class="space-y-2">
                            <div class="flex justify-between items-center">
                                <span class="text-slate-500">Nominal:</span>
                                <span class="font-bold text-red-600">Rp ${formatRupiah(nominal)}</span>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="text-slate-500">Tanggal:</span>
                                <span class="font-bold">${tanggal}</span>
                            </div>
                        </div>
                        <div class="bg-red-50 p-3 rounded-lg border border-red-200 mt-3">
                            <p class="text-xs text-red-700 font-bold">
                                <i data-lucide="alert-triangle" class="w-3 h-3 inline mr-1"></i>
                                Peringatan: Saldo Koperasi & Margiyanto akan berkurang!
                            </p>
                        </div>
                    </div>
                `,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#b91c1c',
                cancelButtonColor: '#64748b',
                confirmButtonText: '<i data-lucide="check" class="w-4 h-4 inline mr-1"></i> Ya, Simpan',
                cancelButtonText: '<i data-lucide="x" class="w-4 h-4 inline mr-1"></i> Batal',
                didOpen: () => {
                    lucide.createIcons();
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    // Show loading
                    Swal.fire({
                        title: 'Memproses...',
                        html: '<div class="flex justify-center"><div class="w-8 h-8 border-4 border-red-500 border-t-transparent rounded-full animate-spin"></div></div>',
                        allowOutsideClick: false,
                        showConfirmButton: false,
                        didOpen: () => {
                            Swal.showLoading();
                        }
                    });

                    // Submit the form
                    const formData = new FormData(this);
                    
                    fetch(window.location.href, {
                        method: 'POST',
                        body: formData
                    })
                    .then(response => response.text())
                    .then(html => {
                        // Check if it was successful
                        if (html.includes('success')) {
                            // Calculate new balances for display
                            const newSaldoGlobal = <?= $saldo_global_lama ?> - parseInt(nominal);
                            const newSaldoMargiyanto = <?= $saldo_margiyanto_lama ?> - parseInt(nominal);
                            
                            Swal.fire({
                                icon: 'success',
                                title: 'Berhasil!',
                                html: `
                                    <div class="text-center">
                                        <p class="font-bold text-green-700 mb-3">Transaksi berhasil disimpan!</p>
                                        <div class="bg-green-50 p-3 rounded-lg border border-green-200 space-y-2">
                                            <div class="flex justify-between items-center">
                                                <span class="text-xs text-slate-600">Saldo Koperasi Baru:</span>
                                                <span class="font-bold text-blue-600 text-sm">Rp ${formatRupiah(newSaldoGlobal)}</span>
                                            </div>
                                            <div class="flex justify-between items-center">
                                                <span class="text-xs text-slate-600">Saldo Margiyanto Baru:</span>
                                                <span class="font-bold text-red-600 text-sm">Rp ${formatRupiah(newSaldoMargiyanto)}</span>
                                            </div>
                                        </div>
                                    </div>
                                `,
                                confirmButtonColor: '#10b981',
                                timer: 2500,
                                timerProgressBar: true
                            }).then(() => {
                                // Reload the page to show updated balances
                                window.location.reload();
                            });
                        } else {
                            // Extract error message from the response
                            const parser = new DOMParser();
                            const doc = parser.parseFromString(html, 'text/html');
                            const errorMsg = doc.querySelector('.text-red-800')?.textContent || 'Terjadi kesalahan saat menyimpan data';
                            
                            Swal.fire({
                                icon: 'error',
                                title: 'Gagal!',
                                text: errorMsg,
                                confirmButtonColor: '#dc2626'
                            });
                        }
                    })
                    .catch(error => {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Terjadi kesalahan: ' + error.message,
                            confirmButtonColor: '#dc2626'
                        });
                    });
                }
            });
        });
    </script>
</body>
</html>