<?php
include '../config.php';
session_start();

// 1. Proteksi Halaman
if (!isset($_SESSION['username']) || ($_SESSION['username'] !== 'margiyanto' && $_SESSION['role'] !== 'user')) {
    header("Location: ../login.php");
    exit;
}

$message = "";
$msg_type = "";

// Ambil Saldo Koperasi Global
$q_saldo_koperasi = mysqli_query($conn, "SELECT saldo_utama_akhir FROM saldo_koperasi ORDER BY id DESC LIMIT 1");
$d_saldo_koperasi = mysqli_fetch_assoc($q_saldo_koperasi);
$saldo_koperasi_lama = $d_saldo_koperasi ? $d_saldo_koperasi['saldo_utama_akhir'] : 0;

// Ambil Saldo Awal Margiyanto
$query_last = "SELECT saldo_akhir FROM data_margiyanto ORDER BY tanggal DESC, id DESC LIMIT 1"; 
$result_last = mysqli_query($conn, $query_last);
$data_last = mysqli_fetch_assoc($result_last);
$saldo_terakhir_db = $data_last ? $data_last['saldo_akhir'] : 0; 

// 2. Proses Form Submit
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $tanggal = $_POST['tanggal'];
    
    // Data Transit (Pengeluaran/Transfer)
    $transit_via     = $_POST['transit_via']; 
    $transit_nominal = str_replace('.', '', $_POST['transit_nominal']);
    if($transit_nominal == "") $transit_nominal = 0;
    
    // Data Pemasukan Margiyanto
    $simpanan_wajib    = str_replace('.', '', $_POST['simpanan_wajib']);
    $tata_usaha        = str_replace('.', '', $_POST['tata_usaha']);
    $angsuran_pinjaman = str_replace('.', '', $_POST['angsuran_pinjaman']);

    if($simpanan_wajib == "") $simpanan_wajib = 0;
    if($tata_usaha == "") $tata_usaha = 0;
    if($angsuran_pinjaman == "") $angsuran_pinjaman = 0;

    if (empty($tanggal)) {
        $message = "Tanggal wajib diisi!";
        $msg_type = "error";
    } else {
        
        // --- LOGIKA HITUNG SALDO ---
        $total_pemasukan = $simpanan_wajib + $tata_usaha + $angsuran_pinjaman;
        
        // Rumus: Saldo Awal (dari DB) + Uang Masuk - Uang Keluar (Transit)
        $saldo_awal_transaksi = $saldo_terakhir_db; 
        $saldo_akhir_baru     = ($saldo_awal_transaksi + $total_pemasukan) - $transit_nominal;

        // Hitung saldo koperasi baru
        $saldo_koperasi_baru = $saldo_koperasi_lama + $total_pemasukan;

        // A. SIMPAN KE SALDO KOPERASI
        $ket_koperasi = "Uang Masuk dari Margiyanto";
        $query_koperasi = "INSERT INTO saldo_koperasi 
                           (tanggal, saldo_utama, saldo_utama_akhir, keterangan) 
                           VALUES 
                           ('$tanggal', '$saldo_koperasi_lama', '$saldo_koperasi_baru', '$ket_koperasi')";
        $simpan_koperasi = mysqli_query($conn, $query_koperasi);

        // B. SIMPAN KE DATA MARGIYANTO
        $query = "INSERT INTO data_margiyanto 
                  (tanggal, transit_via, transit_nominal, simpanan_wajib, tata_usaha, angsuran_pinjaman, saldo_awal, saldo_akhir) 
                  VALUES 
                  ('$tanggal', '$transit_via', '$transit_nominal', '$simpanan_wajib', '$tata_usaha', '$angsuran_pinjaman', '$saldo_awal_transaksi', '$saldo_akhir_baru') 
                  ON DUPLICATE KEY UPDATE 
                  transit_via = '$transit_via',
                  transit_nominal = '$transit_nominal',
                  simpanan_wajib = '$simpanan_wajib',
                  tata_usaha = '$tata_usaha',
                  angsuran_pinjaman = '$angsuran_pinjaman',
                  saldo_awal = '$saldo_awal_transaksi',
                  saldo_akhir = '$saldo_akhir_baru'";

        $simpan_margiyanto = mysqli_query($conn, $query);

        // C. LOGIKA TRANSIT
        $transfer_sukses = true;

        if (!empty($transit_via) && $transit_nominal > 0) {
            $tabel_target = "";
            if ($transit_via == 'Jaitun') {
                $tabel_target = "data_jaitun";
            } elseif ($transit_via == 'Maulana') {
                $tabel_target = "data_maulana";
            }

            if ($tabel_target != "") {
                $ket_transit = "Transit dari Margiyanto";
                $q_target_last = "SELECT saldo_akhir FROM $tabel_target ORDER BY tanggal DESC, id DESC LIMIT 1";
                $res_target_last = mysqli_query($conn, $q_target_last);
                $data_target_last = mysqli_fetch_assoc($res_target_last);
                
                $saldo_awal_target = $data_target_last ? $data_target_last['saldo_akhir'] : 0;
                $saldo_akhir_target = $saldo_awal_target + $transit_nominal;

                $query_transfer = "INSERT INTO $tabel_target (tanggal, keterangan, masuk, saldo_awal, saldo_akhir) 
                                   VALUES ('$tanggal', '$ket_transit', '$transit_nominal', '$saldo_awal_target', '$saldo_akhir_target') 
                                   ON DUPLICATE KEY UPDATE 
                                   masuk = masuk + $transit_nominal,
                                   saldo_akhir = saldo_akhir + $transit_nominal"; 
                
                if (!mysqli_query($conn, $query_transfer)) {
                    $transfer_sukses = false;
                }
            }
        }

        // D. Feedback
        if ($simpan_koperasi && $simpan_margiyanto && $transfer_sukses) {
            $msg_type = "success";
            $message = "success"; // Kunci untuk trigger JS
            
            $tampil_saldo_awal = $saldo_akhir_baru;
            $tampil_saldo_koperasi = $saldo_koperasi_baru;

        } else {
            $message = "Gagal menyimpan. Error: " . mysqli_error($conn);
            $msg_type = "error";
            $tampil_saldo_awal = $saldo_terakhir_db;
            $tampil_saldo_koperasi = $saldo_koperasi_lama;
        }
    }
} else {
    $tampil_saldo_awal = $saldo_terakhir_db;
    $tampil_saldo_koperasi = $saldo_koperasi_lama;
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Input Uang Masuk - Margiyanto</title>
    <link rel="icon" href="../icon.png" type="image/png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>

    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; -webkit-tap-highlight-color: transparent; }
        .card-glow { box-shadow: 0 0 20px rgba(34, 197, 94, 0.3); }
        .input-focus { transition: all 0.3s ease; }
        .input-focus:focus { box-shadow: 0 0 0 3px rgba(34, 197, 94, 0.2); }
    </style>
</head>
<body class="bg-gradient-to-br from-green-50 to-emerald-50 min-h-screen pb-10">

    <nav class="bg-gradient-to-r from-green-900 to-emerald-900 text-white shadow-lg p-4 sticky top-0 z-50 border-b border-green-800/50">
        <div class="max-w-xl mx-auto flex justify-between items-center">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-gradient-to-br from-green-500 to-emerald-600 rounded-xl flex items-center justify-center font-bold shadow-lg shadow-green-500/30">
                    <i data-lucide="arrow-down-left" class="w-6 h-6"></i>
                </div>
                <div>
                    <h1 class="font-bold text-lg leading-tight">Uang Masuk</h1>
                    <p class="text-[10px] text-green-200 uppercase tracking-widest font-bold flex items-center gap-1">
                        <i data-lucide="user" class="w-3 h-3"></i>
                        Margiyanto
                    </p>
                </div>
            </div>
            <a href="javascript:history.back()" class="w-8 h-8 flex items-center justify-center bg-white/10 rounded-full hover:bg-white/20 transition-all active:scale-90">
                <i data-lucide="x" class="w-4 h-4"></i>
            </a>
        </div>
    </nav>

    <main class="max-w-xl mx-auto p-5">
        
        <div class="mb-5 grid grid-cols-1 gap-4">
            <div class="bg-gradient-to-br from-green-600 to-emerald-700 rounded-2xl p-5 text-white shadow-lg card-glow border border-green-800/50">
                <div class="flex items-center justify-between mb-3">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-green-500/30 rounded-xl flex items-center justify-center">
                            <i data-lucide="building-2" class="w-5 h-5"></i>
                        </div>
                        <p class="text-green-100 text-xs font-bold uppercase tracking-wider">Saldo Koperasi</p>
                    </div>
                    <span class="px-3 py-1 bg-green-500/20 text-green-200 text-xs font-bold rounded-full">Global</span>
                </div>
                <h3 class="text-2xl font-bold mb-1">Rp <?= number_format($tampil_saldo_koperasi, 0, ',', '.') ?></h3>
            </div>

            <div class="bg-white p-5 rounded-2xl shadow-sm border border-slate-100">
                <div class="flex items-center justify-between mb-3">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-green-100 rounded-xl flex items-center justify-center text-green-600">
                            <i data-lucide="wallet" class="w-5 h-5"></i>
                        </div>
                        <p class="text-slate-400 text-xs font-bold uppercase tracking-wider">Saldo Margiyanto</p>
                    </div>
                    <span class="px-3 py-1 bg-green-50 text-green-700 text-xs font-bold rounded-full">Personal</span>
                </div>
                <h3 class="text-2xl font-bold text-slate-800 mb-1">Rp <?= number_format($tampil_saldo_awal, 0, ',', '.') ?></h3>
            </div>
        </div>

        <form action="" method="POST" class="space-y-5" id="transactionForm">
            <div class="bg-white p-5 rounded-2xl shadow-sm border border-slate-100 space-y-4">
                <div>
                    <label class="block text-xs font-bold text-slate-400 uppercase tracking-wider mb-2 flex items-center gap-2">
                        <i data-lucide="calendar" class="w-3 h-3"></i>
                        Tanggal Transaksi
                    </label>
                    <input type="date" name="tanggal" required value="<?= date('Y-m-d') ?>" class="w-full bg-slate-50 border border-slate-200 text-slate-800 text-sm rounded-xl focus:ring-2 focus:ring-green-500 block p-3 font-bold outline-none input-focus">
                </div>
            </div>

            <div class="bg-gradient-to-br from-indigo-50 to-blue-50 p-5 rounded-2xl border border-indigo-200 relative overflow-hidden">
                <div class="absolute inset-0 bg-[radial-gradient(circle_at_50%_50%,rgba(99,102,241,0.1),transparent_70%)]"></div>
                <div class="relative z-10">
                    <h3 class="font-bold text-indigo-900 mb-2 flex items-center gap-2">
                        <i data-lucide="route" class="w-5 h-5"></i>
                        Fitur Transit
                    </h3>
                    <p class="text-xs text-indigo-600 mb-4">Saldo akan otomatis masuk ke data Jaitun/Maulana.</p>
                    <div class="space-y-4">
                        <div>
                            <label class="block text-[10px] font-bold text-indigo-500 uppercase tracking-wider mb-1 flex items-center gap-1">
                                <i data-lucide="arrow-right-left" class="w-3 h-3"></i>
                                Tujuan Transit
                            </label>
                            <select name="transit_via" id="transit_via" class="w-full bg-white border border-indigo-200 text-slate-700 text-sm rounded-xl focus:ring-2 focus:ring-indigo-500 block p-3 font-bold outline-none input-focus">
                                <option value="">-- Tidak Ada --</option>
                                <option value="Jaitun">Jaitun</option>
                                <option value="Maulana">Maulana</option>
                            </select>
                        </div>
                        <div>
                            <label class="block text-[10px] font-bold text-indigo-500 uppercase tracking-wider mb-1 flex items-center gap-1">
                                <i data-lucide="dollar-sign" class="w-3 h-3"></i>
                                Nominal Transit
                            </label>
                            <input type="text" name="transit_nominal" id="transit_nominal" placeholder="0" onkeyup="formatRupiah(this)" class="w-full bg-white border border-indigo-200 text-slate-800 text-sm rounded-xl focus:ring-2 focus:ring-indigo-500 block p-3 font-bold outline-none input-focus">
                        </div>
                    </div>
                </div>
            </div>

            <div class="bg-white p-5 rounded-2xl shadow-sm border border-slate-100 space-y-4">
                <h3 class="font-bold text-slate-800 border-b border-slate-100 pb-2 mb-2 flex items-center gap-2">
                    <i data-lucide="receipt" class="w-5 h-5 text-green-600"></i>
                    Rincian Pembayaran
                </h3>
                <div>
                    <label class="block text-xs font-bold text-slate-500 mb-1 flex items-center gap-2">
                        <i data-lucide="piggy-bank" class="w-4 h-4 text-slate-400"></i>
                        Simpanan Wajib
                    </label>
                    <input type="text" name="simpanan_wajib" id="simpanan_wajib" placeholder="0" onkeyup="formatRupiah(this)" class="w-full bg-slate-50 border border-slate-200 text-slate-800 rounded-xl focus:ring-2 focus:ring-green-500 block p-3 font-bold outline-none input-focus">
                </div>
                <div>
                    <label class="block text-xs font-bold text-slate-500 mb-1 flex items-center gap-2">
                        <i data-lucide="file-text" class="w-4 h-4 text-slate-400"></i>
                        Tata Usaha (TU)
                    </label>
                    <input type="text" name="tata_usaha" id="tata_usaha" placeholder="0" onkeyup="formatRupiah(this)" class="w-full bg-slate-50 border border-slate-200 text-slate-800 rounded-xl focus:ring-2 focus:ring-green-500 block p-3 font-bold outline-none input-focus">
                </div>
                <div>
                    <label class="block text-xs font-bold text-green-600 mb-1 flex items-center gap-2">
                        <i data-lucide="credit-card" class="w-4 h-4 text-green-500"></i>
                        Angsuran Pinjaman
                    </label>
                    <input type="text" name="angsuran_pinjaman" id="angsuran_pinjaman" placeholder="0" onkeyup="formatRupiah(this)" class="w-full bg-green-50 border border-green-200 text-slate-800 rounded-xl focus:ring-2 focus:ring-green-500 block p-3 font-bold outline-none input-focus">
                </div>
            </div>

            <button type="submit" class="w-full bg-gradient-to-r from-green-600 to-emerald-700 hover:from-green-700 hover:to-emerald-800 text-white font-bold rounded-xl text-sm px-5 py-4 shadow-xl shadow-green-500/30 flex justify-center items-center gap-2 transition-all active:scale-95">
                <i data-lucide="save" class="w-5 h-5"></i>
                <span>Simpan Transaksi</span>
            </button>
        </form>
    </main>

    <div id="receipt-node" style="position: absolute; top: -9999px; left: -9999px; width: 400px;" class="bg-white p-6 rounded-none border border-gray-200 text-slate-800 font-sans">
        <div class="text-center border-b-2 border-dashed border-gray-300 pb-4 mb-4">
            <h2 class="text-xl font-bold text-emerald-800 uppercase tracking-wider">Bukti Transaksi</h2>
            <p class="text-xs text-slate-500">Koperasi & Keuangan</p>
            <p class="text-[10px] text-slate-400 mt-1" id="receipt-date">Tanggal: -</p>
        </div>
        
        <div class="mb-4">
            <div class="flex justify-between items-center mb-1">
                <span class="text-xs font-bold text-slate-500">Nama Akun</span>
                <span class="text-xs font-bold text-slate-800">MARGIYANTO</span>
            </div>
            <div class="flex justify-between items-center">
                <span class="text-xs text-slate-500">Tipe</span>
                <span class="text-xs font-bold text-emerald-600 bg-emerald-50 px-2 py-0.5 rounded">Uang Masuk</span>
            </div>
        </div>

        <div class="space-y-2 border-t border-gray-100 pt-3 pb-3">
            <div id="row-sw" class="flex justify-between text-sm hidden">
                <span class="text-slate-600">Simpanan Wajib</span>
                <span class="font-bold" id="val-sw">Rp 0</span>
            </div>
            <div id="row-tu" class="flex justify-between text-sm hidden">
                <span class="text-slate-600">Tata Usaha</span>
                <span class="font-bold" id="val-tu">Rp 0</span>
            </div>
            <div id="row-angsuran" class="flex justify-between text-sm hidden">
                <span class="text-slate-600">Angsuran</span>
                <span class="font-bold" id="val-angsuran">Rp 0</span>
            </div>
            <div id="row-transit" class="flex justify-between text-sm text-indigo-600 hidden">
                <span class="font-medium" id="lbl-transit">Transit via -</span>
                <span class="font-bold" id="val-transit">Rp 0</span>
            </div>
        </div>

        <div class="border-t-2 border-dashed border-gray-300 pt-3 mt-1">
            <div class="flex justify-between items-center text-lg font-bold">
                <span class="text-slate-800">Total</span>
                <span class="text-emerald-700" id="val-total">Rp 0</span>
            </div>
        </div>

        <div class="mt-6 text-center">
            <p class="text-[10px] text-slate-400 italic">Dicetak otomatis oleh sistem</p>
            <p class="text-[8px] text-slate-300 mt-1">ID: <?= uniqid() ?></p>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <script>
        lucide.createIcons();

        function formatRupiah(input) {
            let value = input.value.replace(/\D/g, "");
            value = new Intl.NumberFormat('id-ID').format(value);
            input.value = value === '0' ? '' : value;
        }

        const fmt = (num) => new Intl.NumberFormat('id-ID').format(num);

        document.getElementById('transactionForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const tanggal = this.tanggal.value;
            const simpananWajib = this.simpanan_wajib.value.replace(/\D/g, '') || 0;
            const tataUsaha = this.tata_usaha.value.replace(/\D/g, '') || 0;
            const angsuranPinjaman = this.angsuran_pinjaman.value.replace(/\D/g, '') || 0;
            
            // Transit
            const transitVia = document.getElementById('transit_via').value;
            const transitNominal = document.getElementById('transit_nominal').value.replace(/\D/g, '') || 0;
            
            const totalPemasukan = parseInt(simpananWajib) + parseInt(tataUsaha) + parseInt(angsuranPinjaman);

            if (!tanggal) {
                Swal.fire({ icon: 'error', title: 'Error!', text: 'Tanggal wajib diisi!' });
                return;
            }

            if (totalPemasukan === 0 && transitNominal === 0) {
                Swal.fire({ icon: 'warning', title: 'Kosong', text: 'Nominal harus diisi!' });
                return;
            }

            // --- PERSIAPAN DATA STRUK ---
            // Kita isi data ke elemen tersembunyi dulu sebelum submit
            document.getElementById('receipt-date').innerText = "Tanggal: " + tanggal;
            
            // Reset visibility row
            document.getElementById('row-sw').classList.add('hidden');
            document.getElementById('row-tu').classList.add('hidden');
            document.getElementById('row-angsuran').classList.add('hidden');
            document.getElementById('row-transit').classList.add('hidden');

            if(simpananWajib > 0) {
                document.getElementById('row-sw').classList.remove('hidden');
                document.getElementById('val-sw').innerText = "Rp " + fmt(simpananWajib);
            }
            if(tataUsaha > 0) {
                document.getElementById('row-tu').classList.remove('hidden');
                document.getElementById('val-tu').innerText = "Rp " + fmt(tataUsaha);
            }
            if(angsuranPinjaman > 0) {
                document.getElementById('row-angsuran').classList.remove('hidden');
                document.getElementById('val-angsuran').innerText = "Rp " + fmt(angsuranPinjaman);
            }
            if(transitNominal > 0) {
                document.getElementById('row-transit').classList.remove('hidden');
                document.getElementById('lbl-transit').innerText = "Transit (" + transitVia + ")";
                document.getElementById('val-transit').innerText = "Rp " + fmt(transitNominal);
            }

            // Hitung Total yang tampil di struk (Gabungan Pemasukan + Transit)
            // Tergantung selera, apakah total di struk itu uang yang "keluar dari kantong" atau saldo masuk
            // Disini saya buat total nominal yang terlibat
            let totalTransaksi = parseInt(totalPemasukan) + parseInt(transitNominal);
            document.getElementById('val-total').innerText = "Rp " + fmt(totalTransaksi);

            // --- PROSES AJAX ---
            Swal.fire({
                title: 'Konfirmasi',
                text: "Simpan data transaksi ini?",
                icon: 'question',
                showCancelButton: true,
                confirmButtonText: 'Ya, Simpan',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    Swal.fire({ title: 'Menyimpan...', didOpen: () => Swal.showLoading() });

                    const formData = new FormData(this);
                    fetch(window.location.href, { method: 'POST', body: formData })
                    .then(response => response.text())
                    .then(html => {
                        if (html.includes('success')) {
                            // --- SUKSES ---
                            Swal.fire({
                                icon: 'success',
                                title: 'Berhasil!',
                                text: 'Data tersimpan.',
                                showCancelButton: true,
                                confirmButtonColor: '#10b981',
                                cancelButtonColor: '#64748b',
                                confirmButtonText: '<i class="fa fa-download"></i> Download Struk',
                                cancelButtonText: 'Tutup'
                            }).then((res) => {
                                if (res.isConfirmed) {
                                    // USER MAU DOWNLOAD GAMBAR
                                    generateAndDownloadReceipt();
                                } else {
                                    window.location.reload();
                                }
                            });
                        } else {
                            // Coba parsing error dari HTML response
                            const parser = new DOMParser();
                            const doc = parser.parseFromString(html, 'text/html');
                            const err = doc.querySelector('.text-red-800')?.textContent || 'Gagal menyimpan.';
                            Swal.fire('Gagal', err, 'error');
                        }
                    })
                    .catch(err => Swal.fire('Error', err.message, 'error'));
                }
            });
        });

        // Fungsi Generate Gambar dari HTML
        function generateAndDownloadReceipt() {
            const node = document.getElementById('receipt-node');
            
            // Tampilkan loading sebentar
            Swal.fire({
                title: 'Memproses Struk...',
                html: 'Sedang membuat gambar JPG...',
                allowOutsideClick: false,
                didOpen: () => Swal.showLoading()
            });

            // html2canvas opsinya
            html2canvas(node, {
                scale: 2, // Biar tajam (HD)
                backgroundColor: "#ffffff",
                useCORS: true
            }).then(canvas => {
                // Convert canvas ke link download
                const link = document.createElement('a');
                link.download = 'Struk_Margiyanto_' + new Date().getTime() + '.jpg';
                link.href = canvas.toDataURL('image/jpeg', 0.9);
                link.click();

                // Setelah download, reload halaman
                setTimeout(() => {
                    window.location.reload();
                }, 1000);
            }).catch(err => {
                console.error(err);
                Swal.fire('Error', 'Gagal membuat gambar struk', 'error');
            });
        }
    </script>
</body>
</html>