<?php
include '../config.php';
session_start();

// 1. Proteksi Halaman
if (!isset($_SESSION['username']) || ($_SESSION['username'] !== 'margiyanto' && $_SESSION['role'] !== 'admin')) {
    header("Location: ../login.php");
    exit;
}

/** * 2. Ambil Data
 * Kita mengambil baris terakhir untuk Saldo Akhir (Real-time),
 * Namun kita juga mengambil SUM (Total) untuk pengeluaran dan kemacetan jika diperlukan.
 */

// Query untuk mendapatkan baris paling terakhir (berdasarkan ID terbesar)
$query_latest = "SELECT * FROM data_margiyanto ORDER BY id DESC LIMIT 1";
$result_latest = mysqli_query($conn, $query_latest);
$data = mysqli_fetch_assoc($result_latest);

// Jika database masih kosong
if (!$data) {
    $data = [
        'tanggal' => date('Y-m-d'),
        'saldo_awal' => 0,
        'macet' => 0,
        'keluar' => 0,
        'saldo_akhir' => 0
    ];
}

// Inisialisasi Variabel untuk Tampilan
$tanggal_data = $data['tanggal'];
$s_awal       = $data['saldo_awal'];
$s_macet = mysqli_fetch_assoc(mysqli_query($conn, "SELECT SUM(macet) as total FROM data_margiyanto"))['total'];// Mengambil nilai macet dari record terakhir
$s_keluar     = $data['keluar']; // Mengambil nilai keluar dari record terakhir
$total_marg   = $data['saldo_akhir']; 

// Ambil Saldo Koperasi Global
$q_saldo_koperasi = mysqli_query($conn, "SELECT saldo_utama_akhir FROM saldo_koperasi ORDER BY id DESC LIMIT 1");
$d_saldo_koperasi = mysqli_fetch_assoc($q_saldo_koperasi);
$saldo_koperasi = $d_saldo_koperasi ? $d_saldo_koperasi['saldo_utama_akhir'] : 0;
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <link rel="icon" href="../icon.png" type="image/png">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Dashboard Margiyanto</title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest"></script>
    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; -webkit-tap-highlight-color: transparent; }
        .mobile-closed { transform: translateY(100%); }
        .mobile-open { transform: translateY(0); }
        #mobileMenuContent { transition: transform 0.3s cubic-bezier(0.4, 0, 0.2, 1); }
        .card-glow { box-shadow: 0 0 20px rgba(59, 130, 246, 0.3); }
        @media (prefers-reduced-motion: no-preference) {
            .animate-float {
                animation: float 3s ease-in-out infinite;
            }
            @keyframes float {
                0%, 100% { transform: translateY(0px); }
                50% { transform: translateY(-10px); }
            }
        }
    </style>
</head>
<body class="bg-gradient-to-br from-slate-50 to-slate-100 min-h-screen pb-24 md:pb-0">

    <nav class="hidden md:block bg-gradient-to-r from-slate-900 to-slate-800 text-white shadow-lg p-4 sticky top-0 z-[100]">
        <div class="max-w-6xl mx-auto flex justify-between items-center">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl flex items-center justify-center font-bold text-white shadow-lg shadow-blue-500/30 animate-float">
                    <i data-lucide="building" class="w-6 h-6"></i>
                </div>
                <div>
                    <h1 class="font-bold text-lg leading-tight">Koperasi Mandiri</h1>
                    <p class="text-[10px] text-slate-400 uppercase tracking-widest font-bold">Margiyanto</p>
                </div>
            </div>
            <div class="flex items-center gap-4">
                <a href="riwayat.php" class="text-sm font-bold text-slate-300 hover:text-white transition-colors mr-4 flex items-center gap-2">
                    <i data-lucide="history" class="w-4 h-4"></i>
                    Riwayat
                </a>
                <div class="relative">
                    <button onclick="toggleDesktopDropdown()" id="desktopDropdownBtn" class="bg-gradient-to-r from-blue-600 to-blue-700 hover:from-blue-700 hover:to-blue-800 px-5 py-2 rounded-xl text-sm font-bold transition-all flex items-center gap-2 shadow-lg shadow-blue-500/30">
                        <i data-lucide="plus" class="w-4 h-4"></i>
                        Input Transaksi
                        <i class="fa-solid fa-chevron-down text-xs ml-1 transition-transform" id="desktopChevron"></i>
                    </button>
                    <div id="desktopDropdownMenu" class="hidden absolute right-0 top-full mt-2 w-56 bg-white rounded-xl shadow-2xl border border-slate-100 overflow-hidden z-[110]">
                        <div class="p-1">
                            <a href="input_masuk.php" class="flex items-center gap-3 px-4 py-3 text-slate-700 hover:bg-green-50 hover:text-green-700 rounded-lg transition-colors group">
                                <div class="w-8 h-8 bg-green-100 rounded-full flex items-center justify-center text-green-600">
                                    <i data-lucide="arrow-down-left" class="w-4 h-4"></i>
                                </div>
                                <div><p class="text-sm font-bold">Uang Masuk</p></div>
                            </a>
                            <a href="input_keluar.php" class="flex items-center gap-3 px-4 py-3 text-slate-700 hover:bg-red-50 hover:text-red-700 rounded-lg transition-colors group">
                                <div class="w-8 h-8 bg-red-100 rounded-full flex items-center justify-center text-red-600">
                                    <i data-lucide="arrow-up-right" class="w-4 h-4"></i>
                                </div>
                                <div><p class="text-sm font-bold">Uang Keluar</p></div>
                            </a>
                        </div>
                    </div>
                </div>
                <a href="../logout.php" onclick="return confirm('Keluar dari sistem?')" class="bg-gradient-to-r from-slate-700 to-red-600 hover:to-red-700 px-5 py-2 rounded-xl text-sm font-bold transition-all flex items-center gap-2 shadow-lg">
                    <i data-lucide="log-out" class="w-4 h-4"></i>
                    Logout
                </a>
            </div>
        </div>
    </nav>

    <header class="md:hidden bg-white px-5 pt-12 pb-4 sticky top-0 z-40 border-b border-slate-100 flex justify-between items-center shadow-sm">
        <div>
            <p class="text-[10px] text-slate-400 font-bold uppercase tracking-wider flex items-center gap-1">
                <i data-lucide="layout-grid" class="w-3 h-3"></i>
                Dashboard
            </p>
            <h1 class="text-xl font-extrabold text-slate-800 flex items-center gap-2">
                Margiyanto 
                <i data-lucide="badge-check" class="w-4 h-4 text-blue-500"></i>
            </h1>
        </div>
        <a href="../logout.php" onclick="return confirm('Logout sekarang?')" class="w-11 h-11 bg-red-50 rounded-2xl flex items-center justify-center text-red-500 active:scale-90 transition-all border border-red-100 shadow-sm hover:bg-red-100">
            <i data-lucide="log-out" class="w-5 h-5"></i>
        </a>
    </header>

    <main class="max-w-6xl mx-auto p-5 md:p-8">
        
        <div class="flex items-center gap-2 mb-6 bg-blue-50 text-blue-700 px-4 py-2 rounded-full text-[11px] font-bold w-fit mx-auto md:mx-0 border border-blue-100">
            <i data-lucide="calendar-check" class="w-3 h-3 mr-1"></i>
            Data Terakhir: <?= date('d M Y', strtotime($tanggal_data)) ?>
        </div>

        <!-- Card Saldo Koperasi Global -->
        <div class="relative bg-gradient-to-br from-blue-600 to-blue-800 rounded-[2.5rem] p-8 md:p-12 shadow-2xl shadow-blue-500/20 mb-8 overflow-hidden text-white border border-blue-900/50 card-glow animate-float">
            <div class="absolute inset-0 bg-[radial-gradient(circle_at_50%_50%,rgba(255,255,255,0.1),transparent_70%)]"></div>
            <div class="relative z-10">
                <div class="flex items-center justify-between mb-4">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-blue-500/30 rounded-xl flex items-center justify-center">
                            <i data-lucide="building-2" class="w-6 h-6"></i>
                        </div>
                        <p class="text-blue-200 text-xs font-bold uppercase tracking-[0.2em]">Saldo Koperasi Global</p>
                    </div>
                    <span class="px-3 py-1 bg-blue-500/20 text-blue-200 text-xs font-bold rounded-full border border-blue-400/30">
                        <i data-lucide="database" class="w-3 h-3 inline mr-1"></i>
                        Real-time
                    </span>
                </div>
                <h2 class="text-4xl md:text-6xl font-black tracking-tight mb-6">
                    <span class="text-blue-300 text-2xl md:text-4xl mr-1">Rp</span><?= number_format($saldo_koperasi, 0, ',', '.') ?>
                </h2>
                <div class="flex items-center gap-3">
                    <div class="flex items-center gap-2 text-[10px] bg-emerald-500/20 text-emerald-400 px-3 py-1.5 rounded-full border border-emerald-500/30 backdrop-blur-sm">
                        <span class="relative flex h-2 w-2">
                            <span class="animate-ping absolute inline-flex h-full w-full rounded-full bg-emerald-400 opacity-75"></span>
                            <span class="relative inline-flex rounded-full h-2 w-2 bg-emerald-500"></span>
                        </span>
                        Sistem Aktif
                    </div>
                    <div class="flex items-center gap-2 text-[10px] bg-blue-500/20 text-blue-300 px-3 py-1.5 rounded-full border border-blue-400/30">
                        <i data-lucide="shield-check" class="w-3 h-3"></i>
                        Terenkripsi
                    </div>
                </div>
            </div>
            <div class="absolute -right-16 -bottom-16 w-64 h-64 bg-blue-500/20 rounded-full blur-[80px]"></div>
            <div class="absolute top-0 right-0 p-8 opacity-10">
                <i data-lucide="building" class="w-32 h-32"></i>
            </div>
        </div>

        <div class="relative bg-gradient-to-br from-slate-900 to-slate-800 rounded-[2.5rem] p-8 md:p-12 shadow-2xl shadow-slate-300 mb-8 overflow-hidden text-white border border-slate-800">
            <div class="absolute inset-0 bg-[radial-gradient(circle_at_50%_50%,rgba(255,255,255,0.05),transparent_70%)]"></div>
            <div class="relative z-10">
                <div class="flex items-center justify-between mb-4">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-orange-500/30 rounded-xl flex items-center justify-center">
                            <i data-lucide="wallet" class="w-6 h-6"></i>
                        </div>
                        <p class="text-slate-400 text-xs font-bold uppercase tracking-[0.2em]">Total Saldo Tersedia</p>
                    </div>
                    <span class="px-3 py-1 bg-orange-500/20 text-orange-300 text-xs font-bold rounded-full border border-orange-400/30">
                        <i data-lucide="trending-up" class="w-3 h-3 inline mr-1"></i>
                        Margiyanto
                    </span>
                </div>
                <h2 class="text-4xl md:text-6xl font-black tracking-tight mb-6">
                    <span class="text-orange-500 text-2xl md:text-4xl mr-1">Rp</span><?= number_format($total_marg, 0, ',', '.') ?>
                </h2>
                <div class="flex items-center gap-3">
                    <div class="flex items-center gap-2 text-[10px] bg-emerald-500/20 text-emerald-400 px-3 py-1.5 rounded-full border border-emerald-500/30 backdrop-blur-sm">
                        <span class="relative flex h-2 w-2">
                            <span class="animate-ping absolute inline-flex h-full w-full rounded-full bg-emerald-400 opacity-75"></span>
                            <span class="relative inline-flex rounded-full h-2 w-2 bg-emerald-500"></span>
                        </span>
                        Sistem Aktif
                    </div>
                    <div class="flex items-center gap-2 text-[10px] bg-orange-500/20 text-orange-300 px-3 py-1.5 rounded-full border border-orange-400/30">
                        <i data-lucide="user" class="w-3 h-3"></i>
                        Personal
                    </div>
                </div>
            </div>
            <div class="absolute -right-16 -bottom-16 w-64 h-64 bg-orange-600/20 rounded-full blur-[80px]"></div>
            <div class="absolute top-0 right-0 p-8 opacity-10">
                <i data-lucide="shield" class="w-32 h-32"></i>
            </div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-8">
            <div class="bg-white p-6 rounded-[2rem] border border-slate-100 shadow-sm flex items-center justify-between hover:shadow-md transition-shadow">
                <div>
                    <p class="text-[10px] text-slate-400 font-bold uppercase mb-1 flex items-center gap-1">
                        <i data-lucide="piggy-bank" class="w-3 h-3"></i>
                        Saldo Awal
                    </p>
                    <p class="text-lg font-bold text-slate-800">Rp <?= number_format($s_awal, 0, ',', '.') ?></p>
                </div>
                <div class="w-12 h-12 bg-slate-50 text-slate-400 rounded-2xl flex items-center justify-center text-xl">
                    <i data-lucide="vault" class="w-6 h-6"></i>
                </div>
            </div>

            <div class="bg-white p-6 rounded-[2rem] border border-orange-100 shadow-sm flex items-center justify-between bg-gradient-to-br from-white to-orange-50/30 hover:shadow-md transition-shadow">
                <div>
                    <p class="text-[10px] text-orange-600 font-bold uppercase mb-1 flex items-center gap-1">
                        <i data-lucide="alert-triangle" class="w-3 h-3"></i>
                        Dana Macet
                    </p>
                    <p class="text-lg font-bold text-orange-700">Rp <?= number_format($s_macet, 0, ',', '.') ?></p>
                </div>
                <div class="w-12 h-12 bg-orange-100 text-orange-600 rounded-2xl flex items-center justify-center text-xl shadow-inner">
                    <i data-lucide="hand-coins" class="w-6 h-6"></i>
                </div>
            </div>

            <div class="bg-white p-6 rounded-[2rem] border border-slate-100 shadow-sm flex items-center justify-between hover:shadow-md transition-shadow">
                <div>
                    <p class="text-[10px] text-rose-500 font-bold uppercase mb-1 flex items-center gap-1">
                        <i data-lucide="arrow-up-right" class="w-3 h-3"></i>
                        Dana Keluar
                    </p>
                    <p class="text-lg font-bold text-rose-600">Rp <?= number_format($s_keluar, 0, ',', '.') ?></p>
                </div>
                <div class="w-12 h-12 bg-rose-50 text-rose-500 rounded-2xl flex items-center justify-center text-xl">
                    <i data-lucide="arrow-up-from-line" class="w-6 h-6"></i>
                </div>
            </div>
        </div>
    </main>

    <nav class="md:hidden fixed bottom-0 left-0 w-full bg-white/80 backdrop-blur-lg border-t border-slate-200 pb-safe z-50 shadow-[0_-10px_25px_rgba(0,0,0,0.05)]">
        <div class="grid grid-cols-3 h-20 items-center">
            <a href="#" class="flex flex-col items-center gap-1 text-blue-600">
                <i data-lucide="home" class="w-6 h-6"></i>
                <span class="text-[10px] font-bold">Beranda</span>
            </a>
            <div class="relative flex justify-center">
                <button onclick="toggleMobileMenu()" class="absolute -top-12 w-16 h-16 bg-gradient-to-br from-blue-500 to-blue-600 rounded-full text-white shadow-xl shadow-blue-500/40 border-[6px] border-slate-50 flex items-center justify-center active:scale-90 transition-all">
                    <i data-lucide="plus" id="mobileMenuIcon" class="w-7 h-7 transition-transform duration-300"></i>
                </button>
            </div>
            <a href="riwayat.php" class="flex flex-col items-center gap-1 text-slate-400">
                <i data-lucide="file-text" class="w-6 h-6"></i>
                <span class="text-[10px] font-bold">Riwayat</span>
            </a>
        </div>
    </nav>

    <div id="mobileBackdrop" onclick="toggleMobileMenu()" class="fixed inset-0 bg-slate-900/60 z-[60] hidden backdrop-blur-sm transition-opacity duration-300"></div>
    
    <div id="mobileMenuContent" class="fixed bottom-0 left-0 w-full bg-white rounded-t-[3rem] z-[70] mobile-closed md:hidden shadow-2xl transition-all duration-300 border-t border-slate-100">
        <div class="flex justify-center pt-4 pb-6">
            <div class="w-12 h-1.5 bg-slate-200 rounded-full"></div>
        </div>
        <div class="px-8 pb-12">
            <div class="mb-6">
                <h3 class="text-xl font-extrabold text-slate-800 flex items-center gap-2">
                    <i data-lucide="plus-circle" class="w-6 h-6 text-blue-600"></i>
                    Buat Transaksi
                </h3>
                <p class="text-xs text-slate-500">Silahkan pilih jenis input data</p>
            </div>
            <div class="grid grid-cols-1 gap-4">
                <a href="input_masuk.php" class="flex items-center p-5 bg-emerald-50 rounded-3xl border border-emerald-100 active:scale-95 transition-all group hover:shadow-md">
                    <div class="w-12 h-12 bg-emerald-500 rounded-2xl flex items-center justify-center text-white text-xl mr-4 shadow-lg shadow-emerald-500/20">
                        <i data-lucide="arrow-down-left" class="w-6 h-6"></i>
                    </div>
                    <div>
                        <h4 class="font-bold text-slate-800">Uang Masuk</h4>
                        <p class="text-[11px] text-emerald-600 font-medium">Tambah saldo koperasi</p>
                    </div>
                </a>
                
                <a href="input_keluar.php" class="flex items-center p-5 bg-rose-50 rounded-3xl border border-rose-100 active:scale-95 transition-all group hover:shadow-md">
                    <div class="w-12 h-12 bg-rose-500 rounded-2xl flex items-center justify-center text-white text-xl mr-4 shadow-lg shadow-rose-500/20">
                        <i data-lucide="arrow-up-right" class="w-6 h-6"></i>
                    </div>
                    <div>
                        <h4 class="font-bold text-slate-800">Uang Keluar</h4>
                        <p class="text-[11px] text-rose-600 font-medium">Catat pengeluaran dana</p>
                    </div>
                </a>
            </div>
        </div>
    </div>

    <script>
        // Initialize Lucide Icons
        lucide.createIcons();

        function toggleDesktopDropdown() {
            const menu = document.getElementById('desktopDropdownMenu');
            const chevron = document.getElementById('desktopChevron');
            menu.classList.toggle('hidden');
            chevron.classList.toggle('rotate-180');
        }

        function toggleMobileMenu() {
            const backdrop = document.getElementById('mobileBackdrop');
            const content = document.getElementById('mobileMenuContent');
            const icon = document.getElementById('mobileMenuIcon');
            
            if (content.classList.contains('mobile-closed')) {
                backdrop.classList.remove('hidden');
                content.classList.remove('mobile-closed');
                content.classList.add('mobile-open');
                icon.classList.add('rotate-45');
            } else {
                content.classList.remove('mobile-open');
                content.classList.add('mobile-closed');
                icon.classList.remove('rotate-45');
                setTimeout(() => backdrop.classList.add('hidden'), 300);
            }
        }

        window.onclick = function(e) {
            if (document.getElementById('desktopDropdownBtn') && !document.getElementById('desktopDropdownBtn').contains(e.target)) {
                document.getElementById('desktopDropdownMenu').classList.add('hidden');
                document.getElementById('desktopChevron').classList.remove('rotate-180');
            }
        }
    </script>
</body>
</html>