<?php
include '../config.php';
session_start();

// 1. Proteksi Halaman
if (!isset($_SESSION['username']) || ($_SESSION['username'] !== 'margiyanto' && $_SESSION['role'] !== 'admin')) {
    header("Location: ../login.php");
    exit;
}

// ==================================================================================
// LOGIKA HAPUS DATA & REVERT (DATA MARGIYANTO)
// ==================================================================================
if (isset($_GET['aksi']) && $_GET['aksi'] == 'hapus' && isset($_GET['id'])) {
    $id_hapus = (int)$_GET['id'];

    // Mulai Transaksi Database (ACID)
    mysqli_begin_transaction($conn);

    try {
        // A. AMBIL DATA YANG MAU DIHAPUS
        $cek = mysqli_query($conn, "SELECT * FROM data_margiyanto WHERE id = '$id_hapus'");
        $data = mysqli_fetch_assoc($cek);

        if ($data) {
            $tanggal_hapus = $data['tanggal'];
            $id_data_hapus = $data['id'];
            $keterangan_asli = $data['keterangan'];
            $transit_via = $data['transit_via'];
            $transit_nominal = (float)$data['transit_nominal'];

            // ----------------------------------------------------------------------
            // 1. HITUNG PERUBAHAN SALDO MARGIYANTO (NET CHANGE)
            // ----------------------------------------------------------------------
            $saldo_awal_row  = (float)$data['saldo_awal'];
            $saldo_akhir_row = (float)$data['saldo_akhir'];
            $perubahan_saldo = $saldo_akhir_row - $saldo_awal_row;
            $revert_value = -$perubahan_saldo; // Balikkan efek

            // ----------------------------------------------------------------------
            // 2. REVERT SALDO KOPERASI — HANYA JIKA BUKAN TRANSIT
            // ----------------------------------------------------------------------
            if (empty($transit_via) || $transit_nominal <= 0) {
                // BUKAN TRANSIT → update saldo koperasi
                $uang_masuk_kop = (float)$data['jasa'] + 
                                  (float)$data['macet'] + 
                                  (float)$data['simpanan_wajib'] + 
                                  (float)$data['tata_usaha'] + 
                                  (float)$data['angsuran_pinjaman']; // ❌ TANPA transit_nominal

                $uang_keluar_kop = (float)$data['keluar'];
                $revisi_saldo_kop = $uang_keluar_kop - $uang_masuk_kop;

                if ($revisi_saldo_kop != 0) {
                    mysqli_query($conn, "UPDATE saldo_koperasi 
                                         SET saldo_utama = saldo_utama + ($revisi_saldo_kop),
                                             saldo_utama_akhir = saldo_utama_akhir + ($revisi_saldo_kop)
                                         WHERE tanggal >= '$tanggal_hapus'");
                }
            }
            // Jika TRANSIT → LEWATI UPDATE SALDO KOPERASI

            // ----------------------------------------------------------------------
            // 3. REVERT SALDO PIHAK LAIN & HAPUS DATA OTOMATIS (JIKA TRANSIT)
            // ----------------------------------------------------------------------
            if (!empty($transit_via) && $transit_nominal > 0) {
                $tabel_target = "";
                if (stripos($transit_via, 'Jaitun') !== false) {
                    $tabel_target = "data_jaitun";
                } elseif (stripos($transit_via, 'Maulana') !== false) {
                    $tabel_target = "data_maulana";
                }

                if ($tabel_target !== "") {
                    // A. Kurangi saldo masa depan di target
                    mysqli_query($conn, "UPDATE $tabel_target 
                                         SET saldo_awal = saldo_awal - $transit_nominal,
                                             saldo_akhir = saldo_akhir - $transit_nominal
                                         WHERE tanggal > '$tanggal_hapus'");

                    // B. HAPUS DATA DI TARGET SECARA OTOMATIS (tanpa fallback manual)
                    $query_hapus_target = "DELETE FROM $tabel_target 
                                           WHERE tanggal = '$tanggal_hapus' 
                                           AND (
                                               (masuk = '$transit_nominal' AND keterangan LIKE '%Margiyanto%')
                                               OR 
                                               (transit_nominal = '$transit_nominal' AND keterangan LIKE '%Margiyanto%')
                                           )
                                           LIMIT 1";
                    mysqli_query($conn, $query_hapus_target);

                    // C. Jika tidak ada yang terhapus, coba hapus berdasarkan pola umum
                    if (mysqli_affected_rows($conn) == 0) {
                        // Alternatif: hapus berdasarkan nominal dan tanggal saja (asumsi unik per hari)
                        mysqli_query($conn, "DELETE FROM $tabel_target 
                                             WHERE tanggal = '$tanggal_hapus' 
                                             AND (masuk = '$transit_nominal' OR transit_nominal = '$transit_nominal')
                                             LIMIT 1");
                    }

                    // D. Jika masih gagal, kurangi saldo hari itu sebagai jaminan konsistensi
                    if (mysqli_affected_rows($conn) == 0) {
                        mysqli_query($conn, "UPDATE $tabel_target 
                                             SET saldo_akhir = saldo_akhir - $transit_nominal 
                                             WHERE tanggal = '$tanggal_hapus'");
                    }
                }
            }

            // ----------------------------------------------------------------------
            // 4. UPDATE SALDO MARGIYANTO (RUNNING BALANCE)
            // ----------------------------------------------------------------------
            mysqli_query($conn, "UPDATE data_margiyanto 
                                 SET saldo_awal = saldo_awal + ($revert_value),
                                     saldo_akhir = saldo_akhir + ($revert_value)
                                 WHERE (tanggal > '$tanggal_hapus') 
                                    OR (tanggal = '$tanggal_hapus' AND id > $id_data_hapus)");

            // ----------------------------------------------------------------------
            // 5. HAPUS DATA FISIK MARGIYANTO
            // ----------------------------------------------------------------------
            mysqli_query($conn, "DELETE FROM data_margiyanto WHERE id = '$id_hapus'");

            // Commit Transaksi
            mysqli_commit($conn);
            header("Location: ?msg=deleted");
            exit;
        }
    } catch (Exception $e) {
        mysqli_rollback($conn);
        error_log("Error hapus transaksi: " . $e->getMessage());
        echo "<script>alert('Gagal menghapus transaksi. Silakan coba lagi.'); window.location.href='riwayat.php';</script>";
        exit;
    }
}


// ==================================================================================
// AMBIL SALDO KOPERASI TERAKHIR
// ==================================================================================
$saldo_kop_query = mysqli_query($conn, "SELECT saldo_utama_akhir FROM saldo_koperasi ORDER BY tanggal DESC LIMIT 1");
$saldo_koperasi = 0;
if ($row_saldo = mysqli_fetch_assoc($saldo_kop_query)) {
    $saldo_koperasi = (float)$row_saldo['saldo_utama_akhir'];
}


// AMBIL SEMUA DATA RIWAYAT
$query = "SELECT * FROM data_margiyanto ORDER BY tanggal DESC, id DESC";
$result = mysqli_query($conn, $query);

// Helper function
function formatRupiah($angka) {
    if ($angka == 0 || $angka == NULL) return '-';
    return 'Rp ' . number_format($angka, 0, ',', '.');
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Riwayat Transaksi - Margiyanto</title>
    <link rel="icon" href="../icon.png" type="image/png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <script src="https://unpkg.com/lucide@latest"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; background-color: #f8fafc; }
        .no-scrollbar::-webkit-scrollbar { display: none; }
        .glass-header { background: rgba(255, 255, 255, 0.9); backdrop-filter: blur(10px); }
        .custom-scroll::-webkit-scrollbar { height: 6px; }
        .custom-scroll::-webkit-scrollbar-track { background: #f1f5f9; }
        .custom-scroll::-webkit-scrollbar-thumb { background: #cbd5e1; border-radius: 3px; }
    </style>
</head>
<body class="pb-24 md:pb-10">

    <header class="glass-header px-6 py-4 sticky top-0 z-40 border-b border-slate-200 flex items-center justify-between">
        <div class="flex items-center gap-4">
            <a href="margiyanto_view.php" class="w-10 h-10 rounded-2xl bg-white border border-slate-200 flex items-center justify-center text-slate-600 hover:bg-slate-50 transition-all shadow-sm">
                <i data-lucide="arrow-left" class="w-5 h-5"></i>
            </a>
            <div>
                <h1 class="text-xl font-bold text-slate-900 leading-tight">Riwayat</h1>
                <p class="text-xs font-medium text-slate-500">Log Transaksi</p>
            </div>
        </div>
        <div class="w-10 h-10 bg-indigo-50 text-indigo-600 rounded-2xl flex items-center justify-center border border-indigo-100">
            <i data-lucide="history" class="w-5 h-5"></i>
        </div>
    </header>

    <main class="max-w-7xl mx-auto p-5 md:p-8">
        
        <!-- ========================================
             CARD SALDO KOPERASI
             ======================================== -->
        <div class="mb-6">
            <div class="bg-gradient-to-r from-blue-500 to-indigo-600 p-5 rounded-[24px] shadow-lg text-white relative overflow-hidden">
                <div class="absolute -top-6 -right-6 w-24 h-24 bg-white/20 rounded-full"></div>
                <div class="absolute -bottom-6 -left-6 w-32 h-32 bg-white/10 rounded-full"></div>
                <div class="relative z-10 flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium opacity-90">Saldo Koperasi</p>
                        <p class="text-2xl md:text-3xl font-extrabold mt-1"><?= formatRupiah($saldo_koperasi) ?></p>
                    </div>
                    <div class="w-12 h-12 bg-white/20 backdrop-blur-sm rounded-xl flex items-center justify-center">
                        <i data-lucide="banknote" class="w-6 h-6"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- ========================================
             STATISTIK GRID
             ======================================== -->
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-8">
            <div class="bg-white p-5 rounded-[24px] border border-slate-100 shadow-[0_4px_20px_-10px_rgba(0,0,0,0.05)]">
                <div class="flex items-center gap-3 mb-2">
                    <div class="p-2 bg-rose-50 text-rose-500 rounded-xl"><i data-lucide="layers" class="w-4 h-4"></i></div>
                    <span class="text-xs font-bold text-slate-400 uppercase tracking-wider">Total Data</span>
                </div>
                <p class="text-2xl font-extrabold text-slate-800"><?= mysqli_num_rows($result) ?></p>
            </div>
             <div class="bg-white p-5 rounded-[24px] border border-slate-100 shadow-[0_4px_20px_-10px_rgba(0,0,0,0.05)]">
                <div class="flex items-center gap-3 mb-2">
                    <div class="p-2 bg-blue-50 text-blue-500 rounded-xl"><i data-lucide="calendar-days" class="w-4 h-4"></i></div>
                    <span class="text-xs font-bold text-slate-400 uppercase tracking-wider">Tanggal</span>
                </div>
                <p class="text-lg font-bold text-slate-800"><?= date('d M Y') ?></p>
            </div>
        </div>

        <!-- ========================================
             TABEL DESKTOP
             ======================================== -->
        <div class="hidden md:block bg-white rounded-[32px] shadow-sm border border-slate-200 overflow-hidden">
            <div class="overflow-x-auto custom-scroll">
                <table class="w-full text-sm text-left whitespace-nowrap">
                    <thead class="bg-slate-50 text-slate-500 text-xs uppercase font-bold tracking-wider border-b border-slate-100">
                        <tr>
                            <th class="px-6 py-5">Tanggal</th>
                            <th class="px-4 py-5 text-indigo-600">Simp. Wajib</th>
                            <th class="px-4 py-5 text-indigo-600">Transit</th>
                            <th class="px-4 py-5 text-green-600">Jasa</th>
                            <th class="px-4 py-5 text-orange-500">Macet/Lain</th>
                            <th class="px-4 py-5 text-rose-500">Keluar</th>
                            <th class="px-4 py-5 bg-blue-50/50 text-blue-700">Saldo Akhir</th>
                            <th class="px-6 py-5">Keterangan</th>
                            <th class="px-6 py-5 text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-50">
                        <?php while($row = mysqli_fetch_assoc($result)): ?>
                        <tr class="hover:bg-slate-50/80 transition-colors group">
                            <td class="px-6 py-4 font-bold text-slate-700"><?= date('d/m/Y', strtotime($row['tanggal'])) ?></td>
                            <td class="px-4 py-4 font-medium text-slate-600"><?= formatRupiah($row['simpanan_wajib']) ?></td>
                            <td class="px-4 py-4">
                                <?php if($row['transit_nominal'] > 0): ?>
                                    <div class="flex flex-col">
                                        <span class="font-bold text-slate-700"><?= formatRupiah($row['transit_nominal']) ?></span>
                                        <span class="text-[10px] text-slate-400 font-bold"><?= $row['transit_via'] ?></span>
                                    </div>
                                <?php else: echo '-'; endif; ?>
                            </td>
                            <td class="px-4 py-4 text-green-600 font-bold"><?= formatRupiah($row['jasa']) ?></td>
                            <td class="px-4 py-4 text-orange-500"><?= formatRupiah($row['macet']) ?></td>
                            <td class="px-4 py-4 text-rose-500 font-bold"><?= ($row['keluar'] > 0) ? '-'.formatRupiah($row['keluar']) : '-' ?></td>
                            <td class="px-4 py-4 font-bold text-blue-700 bg-blue-50/20 border-l border-r border-slate-50"><?= formatRupiah($row['saldo_akhir']) ?></td>
                            <td class="px-6 py-4 text-slate-500 italic text-xs max-w-[200px] truncate"><?= $row['keterangan'] ?: '-' ?></td>
                            <td class="px-6 py-4 text-center">
                                <button onclick="hapusTransaksi(<?= $row['id'] ?>, '<?= addslashes($row['transit_via']) ?>')" class="w-8 h-8 rounded-lg bg-rose-50 text-rose-500 hover:bg-rose-500 hover:text-white flex items-center justify-center transition-all">
                                    <i data-lucide="trash-2" class="w-4 h-4"></i>
                                </button>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- ========================================
             CARD MOBILE
             ======================================== -->
        <div class="md:hidden space-y-4">
            <?php 
            mysqli_data_seek($result, 0); 
            while($row = mysqli_fetch_assoc($result)): 
            ?>
            <div class="bg-white p-5 rounded-[24px] border border-slate-100 shadow-sm relative overflow-hidden">
                <button onclick="hapusTransaksi(<?= $row['id'] ?>, '<?= addslashes($row['transit_via']) ?>')" class="absolute top-4 right-4 w-8 h-8 bg-slate-50 text-rose-400 rounded-full flex items-center justify-center border border-slate-100 active:scale-90 transition-transform z-10">
                    <i data-lucide="trash-2" class="w-4 h-4"></i>
                </button>

                <div class="flex flex-col gap-1 mb-4 pr-10">
                    <span class="text-[10px] font-extrabold text-slate-400 uppercase tracking-widest"><?= date('d M Y', strtotime($row['tanggal'])) ?></span>
                    <h3 class="font-bold text-slate-800 text-sm line-clamp-2 leading-relaxed"><?= $row['keterangan'] ?: 'Transaksi Tanpa Keterangan' ?></h3>
                </div>

                <div class="grid grid-cols-2 gap-2 text-xs mb-4">
                    <?php if($row['jasa'] > 0): ?>
                        <div class="bg-green-50/50 p-2.5 rounded-xl border border-green-50">
                            <p class="text-slate-400 text-[10px] mb-0.5">Jasa</p>
                            <p class="font-bold text-green-700"><?= formatRupiah($row['jasa']) ?></p>
                        </div>
                    <?php endif; ?>
                    
                    <?php if($row['simpanan_wajib'] > 0): ?>
                        <div class="bg-indigo-50/50 p-2.5 rounded-xl border border-indigo-50">
                            <p class="text-slate-400 text-[10px] mb-0.5">Wajib</p>
                            <p class="font-bold text-indigo-700"><?= formatRupiah($row['simpanan_wajib']) ?></p>
                        </div>
                    <?php endif; ?>

                    <?php if($row['transit_nominal'] > 0): ?>
                        <div class="col-span-2 bg-slate-50 p-2.5 rounded-xl border border-slate-100 flex justify-between items-center">
                            <div>
                                <p class="text-slate-400 text-[10px]">Transit</p>
                                <p class="text-[10px] font-bold text-slate-500 uppercase"><?= $row['transit_via'] ?></p>
                            </div>
                            <p class="font-bold text-slate-700"><?= formatRupiah($row['transit_nominal']) ?></p>
                        </div>
                    <?php endif; ?>
                </div>

                <div class="flex items-center justify-between pt-3 border-t border-slate-50">
                    <?php if($row['keluar'] > 0): ?>
                        <div>
                            <p class="text-[10px] text-rose-400 font-bold mb-0.5">KELUAR</p>
                            <p class="text-sm font-bold text-rose-600">-<?= formatRupiah($row['keluar']) ?></p>
                        </div>
                    <?php else: ?>
                        <div class="opacity-0">.</div>
                    <?php endif; ?>

                    <div class="text-right">
                        <p class="text-[10px] text-blue-400 font-bold mb-0.5">SALDO AKHIR</p>
                        <p class="text-base font-extrabold text-blue-600"><?= formatRupiah($row['saldo_akhir']) ?></p>
                    </div>
                </div>
            </div>
            <?php endwhile; ?>
        </div>

    </main>

    <script>
        lucide.createIcons();

        function hapusTransaksi(id, transitVia) {
            let msg = "Transaksi akan dihapus dan saldo Margiyanto akan dikembalikan.";
            
            if (transitVia && transitVia.trim() !== '') {
                msg += `\n\nPERHATIAN: Ini adalah transaksi TRANSIT.\nSaldo ${transitVia} akan disesuaikan secara otomatis.\nSALDO KOPERASI TIDAK BERUBAH.`;
            } else {
                msg += "\nSaldo Koperasi juga akan dikembalikan jika diperlukan.";
            }

            Swal.fire({
                title: 'Hapus & Revert Saldo?',
                text: msg,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#ef4444',
                cancelButtonColor: '#94a3b8',
                confirmButtonText: 'Ya, Hapus!',
                cancelButtonText: 'Batal',
                background: '#fff',
                customClass: {
                    popup: 'rounded-[32px]',
                    confirmButton: 'rounded-xl',
                    cancelButton: 'rounded-xl'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = '?aksi=hapus&id=' + id;
                }
            })
        }

        // Notifikasi sukses
        const urlParams = new URLSearchParams(window.location.search);
        if (urlParams.has('msg') && urlParams.get('msg') === 'deleted') {
            Swal.fire({
                icon: 'success',
                title: 'Berhasil Dihapus',
                text: 'Saldo Margiyanto dan pihak terkait telah disesuaikan.',
                timer: 2500,
                showConfirmButton: false,
                background: '#fff',
                customClass: { popup: 'rounded-[32px]' }
            });
            window.history.replaceState({}, document.title, window.location.pathname);
        }
    </script>
</body>
</html>