<?php
session_start();
include '../config.php';

// --- [1. BACKEND] LOGIKA AJAX CEK NAMA ---
if (isset($_POST['ajax_check_name'])) {
    ob_clean(); // Bersihkan buffer output
    $nama = trim($_POST['ajax_check_name']);
    $stmt = $conn->prepare("SELECT id FROM anggota WHERE nama_lengkap = ?");
    $stmt->bind_param("s", $nama);
    $stmt->execute();
    $stmt->store_result();
    echo ($stmt->num_rows > 0) ? "taken" : "available";
    exit;
}

function clean_number($rupiah) { return preg_replace('/[^0-9]/', '', $rupiah); }

// Variabel Notifikasi
$notif = null;

// --- [2. BACKEND] LOGIKA HAPUS ANGGOTA ---
if (isset($_GET['delete_id'])) {
    $id_hapus = $_GET['delete_id'];
    $conn->begin_transaction();
    try {
        $conn->query("DELETE FROM transaksi_sukarela WHERE anggota_id = $id_hapus");
        $conn->query("DELETE FROM anggota WHERE id = $id_hapus");
        $conn->commit();
        $notif = ['type' => 'success', 'title' => 'Terhapus', 'msg' => 'Data anggota berhasil dihapus.'];
    } catch (Exception $e) {
        $conn->rollback();
        $notif = ['type' => 'error', 'title' => 'Gagal', 'msg' => 'Terjadi kesalahan sistem.'];
    }
}

// --- [3. BACKEND] LOGIKA TAMBAH ANGGOTA ---
if (isset($_POST['action']) && $_POST['action'] == 'add_member') {
    $nama = trim($_POST['nama']);
    $saldo_awal = clean_number($_POST['saldo_awal']);
    $cek_nama = $conn->query("SELECT id FROM anggota WHERE nama_lengkap = '$nama'");
    
    if ($cek_nama->num_rows > 0) {
        $notif = ['type' => 'error', 'title' => 'Gagal', 'msg' => 'Nama sudah terdaftar!'];
    } else {
        $no_anggota = "AG" . rand(1000, 9999);
        $stmt = $conn->prepare("INSERT INTO anggota (nama_lengkap, nomor_anggota, saldo_akhir) VALUES (?, ?, ?)");
        $stmt->bind_param("ssd", $nama, $no_anggota, $saldo_awal);
        
        if ($stmt->execute()) {
            $new_id = $stmt->insert_id;
            if ($saldo_awal > 0) {
                $conn->query("INSERT INTO transaksi_sukarela (anggota_id, jenis_transaksi, jumlah, saldo_akhir, keterangan, tanggal_transaksi) 
                              VALUES ($new_id, 'MASUK', $saldo_awal, $saldo_awal, 'Saldo Awal', NOW())");
            }
            $notif = ['type' => 'success', 'title' => 'Berhasil', 'msg' => "Anggota baru ($no_anggota) ditambahkan."];
        }
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Data Anggota</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/lucide@latest"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; background-color: #F8FAFC; -webkit-tap-highlight-color: transparent; }
        .glass { background: rgba(255, 255, 255, 0.7); backdrop-filter: blur(10px); -webkit-backdrop-filter: blur(10px); }
        .no-scrollbar::-webkit-scrollbar { display: none; }
        
        /* Animations */
        @keyframes spin { to { transform: rotate(360deg); } }
        .spinner { border: 3px solid #e2e8f0; border-top: 3px solid #10b981; border-radius: 50%; width: 20px; height: 20px; animation: spin 0.8s linear infinite; }
        
        @keyframes slideUp { from { transform: translateY(100%); opacity: 0; } to { transform: translateY(0); opacity: 1; } }
        .animate-slide-up { animation: slideUp 0.3s cubic-bezier(0.16, 1, 0.3, 1); }
        
        @keyframes fadeIn { from { opacity: 0; } to { opacity: 1; } }
        .animate-fade-in { animation: fadeIn 0.2s ease-out; }
    </style>
</head>
<body class="text-slate-800 pb-24 md:pb-0">

    <nav class="hidden md:block sticky top-0 z-50 glass border-b border-slate-200/60">
        <div class="max-w-7xl mx-auto px-6 h-20 flex items-center justify-between">
            <div class="flex items-center gap-3">
                    <div class="w-10 h-10 rounded-xl shadow-lg shadow-emerald-600/20 overflow-hidden">
                        <img src="../icon.png" alt="Logo" class="w-full h-full object-cover">
                    </div>
                <div>
                    <h1 class="font-bold text-lg tracking-tight leading-none text-slate-900">Koperasi</h1>
                </div>
            </div>
            <div class="flex items-center gap-8">
                <div class="flex gap-1 bg-slate-100/50 p-1 rounded-full border border-slate-200">
                    <a href="index.php" class="px-4 py-2 rounded-full text-sm font-medium text-slate-600 hover:bg-slate-200/50 transition">Dashboard</a>
                                        <a href="input_transaksi.php" class="px-4 py-2 rounded-full text-sm font-medium text-slate-600 hover:bg-slate-200/50 transition">Input</a>
                    <a href="anggota.php" class="px-4 py-2 bg-white rounded-full text-sm font-semibold text-emerald-700 shadow-sm border border-slate-100">Anggota</a>
                    <a href="riwayat.php" class="px-4 py-2 rounded-full text-sm font-medium text-slate-600 hover:bg-slate-200/50 transition">Riwayat</a>
                </div>
                <button onclick="logoutConfirm()" class="text-slate-400 hover:text-rose-500 transition">
                    <i data-lucide="log-out" class="h-5 w-5"></i>
                </button>
            </div>
        </div>
    </nav>

    <div class="md:hidden pt-6 px-6 pb-2">
        <a href="index.php" class="inline-flex items-center gap-2 text-slate-500 hover:text-slate-800 mb-4 transition">
            <i data-lucide="arrow-left" class="h-5 w-5"></i>
            <span class="font-medium text-sm">Kembali</span>
        </a>
        <h1 class="font-bold text-2xl text-slate-900 tracking-tight">Data Anggota</h1>
        <p class="text-slate-500 text-sm mt-1">Kelola daftar anggota koperasi.</p>
    </div>

    <main class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-4 md:py-8">
        
        <div class="relative mb-6">
            <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                <i data-lucide="search" class="h-5 w-5 text-slate-400"></i>
            </div>
            <input type="text" id="cariAnggota" onkeyup="filterAnggota()" 
                   class="block w-full pl-11 pr-4 py-4 bg-white border border-slate-200 rounded-2xl leading-5 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-emerald-500 focus:border-emerald-500 sm:text-sm shadow-sm transition" 
                   placeholder="Cari nama atau nomor anggota...">
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4" id="listAnggota">
            <?php
            $res = $conn->query("SELECT * FROM anggota ORDER BY nama_lengkap ASC");
            if ($res->num_rows > 0) {
                while($row = $res->fetch_assoc()) {
                    // Generate random pastel color based on ID for avatar
                    $colors = ['bg-blue-100 text-blue-600', 'bg-emerald-100 text-emerald-600', 'bg-purple-100 text-purple-600', 'bg-orange-100 text-orange-600'];
                    $color_class = $colors[$row['id'] % 4];
            ?>
            <div class="card-anggota bg-white p-5 rounded-3xl shadow-sm border border-slate-100 hover:shadow-md transition-shadow group relative overflow-hidden">
                <div class="flex justify-between items-start">
                    <div class="flex items-center gap-4">
                        <div class="h-14 w-14 rounded-2xl <?= $color_class ?> flex items-center justify-center font-bold text-xl shadow-inner">
                            <?= strtoupper(substr($row['nama_lengkap'], 0, 1)) ?>
                        </div>
                        <div>
                            <h3 class="nama-anggota font-bold text-slate-900 text-lg leading-tight"><?= htmlspecialchars($row['nama_lengkap']) ?></h3>
                            <p class="id-anggota text-xs text-slate-500 font-medium mt-1 font-mono bg-slate-100 inline-block px-2 py-0.5 rounded-md"><?= $row['nomor_anggota'] ?></p>
                        </div>
                    </div>
                </div>
                
                <div class="mt-6 pt-4 border-t border-slate-50 flex justify-between items-end">
                    <div>
                        <p class="text-[10px] uppercase tracking-wider text-slate-400 font-semibold mb-0.5">Total Saldo</p>
                        <p class="font-bold text-slate-800 text-lg">Rp <?= number_format($row['saldo_akhir'], 0, ',', '.') ?></p>
                    </div>
                    <button onclick="hapusAnggota(<?= $row['id'] ?>, '<?= addslashes($row['nama_lengkap']) ?>')" 
                            class="p-2.5 rounded-xl text-slate-300 hover:text-rose-600 hover:bg-rose-50 transition-colors">
                        <i data-lucide="trash-2" class="h-5 w-5"></i>
                    </button>
                </div>
            </div>
            <?php } } else { ?>
                <div class="col-span-full py-20 flex flex-col items-center justify-center text-slate-400">
                    <i data-lucide="users" class="h-16 w-16 mb-4 opacity-20"></i>
                    <p>Belum ada data anggota.</p>
                </div>
            <?php } ?>
        </div>
    </main>

    <div class="md:hidden fixed bottom-0 left-0 w-full z-50">
        <div class="absolute bottom-0 w-full h-24 bg-gradient-to-t from-white via-white/90 to-transparent pointer-events-none"></div>
        <div class="relative bg-white border-t border-slate-200 px-6 pb-6 pt-3 grid grid-cols-5 items-center">
            <a href="index.php" class="flex flex-col items-center justify-center gap-1 text-slate-400 hover:text-emerald-600 transition">
                <i data-lucide="home" class="h-6 w-6"></i>
                <span class="text-[10px] font-medium">Home</span>
            </a>
            <a href="anggota.php" class="flex flex-col items-center justify-center gap-1 text-emerald-600">
                <i data-lucide="users" class="h-6 w-6 fill-current"></i>
                <span class="text-[10px] font-bold">Anggota</span>
            </a>
            <div class="relative -top-6 flex justify-center">
                <button onclick="openMemberModal()" class="w-14 h-14 bg-slate-900 rounded-full flex items-center justify-center text-white shadow-xl shadow-slate-900/30 border-4 border-white transform active:scale-95 transition">
                    <i data-lucide="plus" class="h-7 w-7"></i>
                </button>
            </div>
            <a href="riwayat.php" class="flex flex-col items-center justify-center gap-1 text-slate-400 hover:text-emerald-600 transition">
                <i data-lucide="history" class="h-6 w-6"></i>
                <span class="text-[10px] font-medium">Riwayat</span>
            </a>
            <button onclick="logoutConfirm()" class="flex flex-col items-center justify-center gap-1 text-slate-400 hover:text-rose-500 transition">
                <i data-lucide="log-out" class="h-6 w-6"></i>
                <span class="text-[10px] font-medium">Keluar</span>
            </button>
        </div>
    </div>

    <div id="memberModal" class="fixed inset-0 bg-slate-900/60 hidden z-[60] backdrop-blur-sm items-end md:items-center justify-center transition-all duration-300">
        <div class="absolute inset-0" onclick="closeModals()"></div>
        <div class="bg-white w-full md:w-[480px] rounded-t-[2rem] md:rounded-[2rem] p-6 md:p-8 animate-slide-up md:animate-fade-in relative z-10 shadow-2xl">
            <div class="w-12 h-1.5 bg-slate-200 rounded-full mx-auto mb-6 md:hidden"></div>
            
            <div class="flex justify-between items-center mb-6">
                <div>
                    <h3 class="text-xl font-bold text-slate-900">Anggota Baru</h3>
                    <p class="text-sm text-slate-500">Daftarkan anggota koperasi baru</p>
                </div>
                <button onclick="closeModals()" class="p-2 bg-slate-100 rounded-full hover:bg-slate-200 transition">
                    <i data-lucide="x" class="h-5 w-5 text-slate-500"></i>
                </button>
            </div>

            <form method="POST" class="space-y-5">
                <input type="hidden" name="action" value="add_member">
                
                <div class="space-y-1.5">
                    <label class="text-sm font-semibold text-slate-700">Nama Lengkap</label>
                    <div class="relative">
                        <input type="text" name="nama" id="inputNama" required autocomplete="off" 
                               class="w-full pl-4 pr-10 py-4 bg-slate-50 border border-slate-200 rounded-2xl focus:ring-2 focus:ring-emerald-500 focus:bg-white focus:border-emerald-500 transition outline-none text-slate-800 placeholder-slate-400" 
                               placeholder="Contoh: Budi Santoso">
                        <div id="loadingIndicator" class="hidden absolute right-4 top-4">
                            <div class="spinner"></div>
                        </div>
                    </div>
                    <p id="feedbackNama" class="text-xs font-bold mt-1 ml-1 hidden"></p>
                </div>

                <div class="space-y-1.5">
                    <label class="text-sm font-semibold text-slate-700">Saldo Awal (Rp)</label>
                    <input type="text" name="saldo_awal" value="0" required onkeyup="formatRupiah(this)" 
                           class="w-full px-4 py-4 bg-slate-50 border border-slate-200 rounded-2xl focus:ring-2 focus:ring-emerald-500 focus:bg-white focus:border-emerald-500 transition outline-none text-slate-800 text-lg font-medium">
                </div>

                <div class="pt-2">
                    <button type="submit" id="btnSubmitAnggota" disabled 
                            class="w-full bg-slate-900 hover:bg-slate-800 text-white font-bold py-4 rounded-2xl shadow-lg shadow-slate-900/20 transition disabled:opacity-50 disabled:cursor-not-allowed">
                        Simpan Anggota
                    </button>
                </div>
            </form>
        </div>
    </div>

    <script>
        lucide.createIcons();

        // --- NOTIFIKASI SYSTEM ---
        <?php if($notif): ?>
            Swal.fire({
                icon: '<?= $notif['type'] ?>',
                title: '<?= $notif['title'] ?>',
                text: '<?= $notif['msg'] ?>',
                confirmButtonColor: '#10b981',
                confirmButtonText: 'Oke',
                customClass: { popup: 'rounded-3xl', confirmButton: 'rounded-xl px-6 py-3' }
            });
        <?php endif; ?>

        // --- FILTER PENCARIAN ---
        function filterAnggota() {
            let input = document.getElementById('cariAnggota').value.toLowerCase();
            let cards = document.getElementsByClassName('card-anggota');
            
            for (let card of cards) {
                let nama = card.querySelector('.nama-anggota').innerText.toLowerCase();
                let id = card.querySelector('.id-anggota').innerText.toLowerCase();
                if (nama.includes(input) || id.includes(input)) {
                    card.classList.remove('hidden');
                } else {
                    card.classList.add('hidden');
                }
            }
        }

        // --- MODAL CONTROLLER ---
        const memberModal = document.getElementById('memberModal');
        function openMemberModal() { 
            memberModal.classList.remove('hidden'); 
            memberModal.classList.add('flex'); 
            document.body.style.overflow = 'hidden';
        }
        function closeModals() { 
            memberModal.classList.add('hidden'); 
            memberModal.classList.remove('flex'); 
            document.body.style.overflow = 'auto';
            resetForm();
        }

        function resetForm() {
            document.getElementById('inputNama').value = '';
            document.getElementById('feedbackNama').classList.add('hidden');
            document.getElementById('inputNama').classList.remove('border-rose-500', 'text-rose-600', 'border-emerald-500', 'text-emerald-600');
            document.getElementById('btnSubmitAnggota').disabled = true;
        }

        // --- CHECK NAME AJAX ---
        const inputNama = document.getElementById('inputNama');
        const feedback = document.getElementById('feedbackNama');
        const btnSubmit = document.getElementById('btnSubmitAnggota');
        const loader = document.getElementById('loadingIndicator');
        let timeout = null;

        if (inputNama) {
            inputNama.addEventListener('input', function() {
                let val = this.value;
                feedback.classList.add('hidden');
                inputNama.classList.remove('border-rose-500', 'text-rose-600', 'border-emerald-500', 'text-emerald-600');
                btnSubmit.disabled = true;

                if (val.length < 3) return; 

                clearTimeout(timeout);
                loader.classList.remove('hidden'); 
                
                timeout = setTimeout(() => {
                    let formData = new FormData();
                    formData.append('ajax_check_name', val);
                    
                    fetch(window.location.href, { method: 'POST', body: formData })
                    .then(r => r.text())
                    .then(status => {
                        loader.classList.add('hidden'); 
                        status = status.trim();
                        feedback.classList.remove('hidden');
                        
                        if (status === 'taken') {
                            feedback.innerHTML = "Nama sudah digunakan";
                            feedback.className = "text-xs font-bold mt-1 ml-1 text-rose-500 block";
                            inputNama.classList.add('border-rose-500', 'text-rose-600');
                            btnSubmit.disabled = true; 
                        } else {
                            feedback.innerHTML = "Nama tersedia";
                            feedback.className = "text-xs font-bold mt-1 ml-1 text-emerald-600 block";
                            inputNama.classList.add('border-emerald-500', 'text-emerald-600');
                            btnSubmit.disabled = false;
                        }
                    })
                    .catch(e => { console.error(e); loader.classList.add('hidden'); });
                }, 600);
            });
        }

        // --- FORMAT RUPIAH ---
        function formatRupiah(input) { 
            let value = input.value.replace(/\D/g, ''); 
            if (value.length > 0) value = value.replace(/\B(?=(\d{3})+(?!\d))/g, "."); 
            input.value = value; 
        }

        // --- KONFIRMASI DELETE & LOGOUT ---
        function hapusAnggota(id, nama) {
            Swal.fire({
                title: 'Hapus Anggota?',
                text: "Data " + nama + " beserta riwayat transaksinya akan hilang permanen.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#f43f5e',
                cancelButtonColor: '#e2e8f0',
                confirmButtonText: 'Ya, Hapus',
                cancelButtonText: '<span style="color:#64748b">Batal</span>',
                customClass: { popup: 'rounded-3xl', confirmButton: 'rounded-xl', cancelButton: 'rounded-xl' }
            }).then((result) => {
                if (result.isConfirmed) window.location.href = "?delete_id=" + id;
            })
        }

        function logoutConfirm() {
            Swal.fire({
                title: 'Keluar?',
                text: "Akhiri sesi anda.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#0f172a',
                cancelButtonColor: '#e2e8f0',
                confirmButtonText: 'Ya',
                cancelButtonText: '<span style="color:#64748b">Batal</span>',
                customClass: { popup: 'rounded-3xl', confirmButton: 'rounded-xl', cancelButton: 'rounded-xl' }
            }).then((result) => {
                if (result.isConfirmed) window.location.href = "index.php?logout=true";
            })
        }
    </script>
</body>
</html>