<?php
session_start();
include '../config.php';

// --- [BAGIAN 1] AJAX HANDLER (WAJIB PALING ATAS) ---
if (isset($_POST['ajax_check_name'])) {
    // Bersihkan output buffer agar tidak ada HTML yang ikut
    ob_clean(); 
    $nama = trim($_POST['ajax_check_name']);
    
    $stmt = $conn->prepare("SELECT id FROM anggota WHERE nama_lengkap = ?");
    $stmt->bind_param("s", $nama);
    $stmt->execute();
    $stmt->store_result();
    
    if ($stmt->num_rows > 0) {
        echo "taken"; 
    } else {
        echo "available"; 
    }
    exit; 
}

// --- FUNGSI FORMAT ANGKA ---
function clean_number($rupiah) {
    return preg_replace('/[^0-9]/', '', $rupiah);
}

// --- LOGIC LOGOUT ---
$pesan = "";
if (isset($_GET['logout'])) {
    session_destroy();
    $pesan = "
    <script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            Swal.fire({
                title: 'Berhasil Keluar',
                text: 'Sampai jumpa kembali!',
                icon: 'success',
                showConfirmButton: false,
                timer: 1500
            }).then(() => {
                window.location='../login.php';
            });
        });
    </script>";
}

// --- LOGIC TAMBAH ANGGOTA ---
if (isset($_POST['action']) && $_POST['action'] == 'add_member') {
    $nama = trim($_POST['nama']);
    $saldo_awal = clean_number($_POST['saldo_awal']);

    $cek_nama = $conn->query("SELECT id FROM anggota WHERE nama_lengkap = '$nama'");
    
    if ($cek_nama->num_rows > 0) {
        $pesan = "<script>document.addEventListener('DOMContentLoaded', function() { Swal.fire({icon: 'error', title: 'Gagal', text: 'Nama sudah terdaftar!', confirmButtonColor: '#10b981'}); });</script>";
    } else {
        $no_anggota = "";
        do {
            $rand = rand(1000, 9999); 
            $candidate = "AG" . $rand;
            $cek = $conn->query("SELECT id FROM anggota WHERE nomor_anggota = '$candidate'");
            if ($cek->num_rows == 0) $no_anggota = $candidate;
        } while ($no_anggota == ""); 

        $stmt = $conn->prepare("INSERT INTO anggota (nama_lengkap, nomor_anggota, saldo_akhir) VALUES (?, ?, ?)");
        $stmt->bind_param("ssd", $nama, $no_anggota, $saldo_awal);
        
        if ($stmt->execute()) {
            $new_id = $stmt->insert_id;
            if ($saldo_awal > 0) {
                $conn->query("INSERT INTO transaksi_sukarela (anggota_id, jenis_transaksi, jumlah, saldo_akhir, keterangan, tanggal_transaksi) 
                              VALUES ($new_id, 'MASUK', $saldo_awal, $saldo_awal, 'Saldo Awal', NOW())");
            }
            $pesan = "<script>document.addEventListener('DOMContentLoaded', function() { Swal.fire({icon: 'success', title: 'Anggota Baru', text: 'ID: $no_anggota berhasil dibuat', confirmButtonColor: '#10b981'}).then(() => { window.location='index.php'; }); });</script>";
        } else {
            $pesan = "<script>document.addEventListener('DOMContentLoaded', function() { Swal.fire('Error', 'Gagal menambah anggota', 'error'); });</script>";
        }
    }
}

// Statistik
$total_aset = $conn->query("SELECT SUM(saldo_akhir) as t FROM anggota")->fetch_assoc()['t'] ?? 0;
$bulan_ini = date('m');
$tahun_ini = date('Y');
$masuk_bulan_ini = $conn->query("SELECT SUM(jumlah) as t FROM transaksi_sukarela WHERE jenis_transaksi='MASUK' AND MONTH(tanggal_transaksi) = '$bulan_ini' AND YEAR(tanggal_transaksi) = '$tahun_ini'")->fetch_assoc()['t'] ?? 0;
$keluar_bulan_ini = $conn->query("SELECT SUM(jumlah) as t FROM transaksi_sukarela WHERE jenis_transaksi='KELUAR' AND MONTH(tanggal_transaksi) = '$bulan_ini' AND YEAR(tanggal_transaksi) = '$tahun_ini'")->fetch_assoc()['t'] ?? 0;
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Sukarela</title>

    <link rel="icon" href="../icon.png" type="image/png">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/lucide@latest"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; background-color: #F8FAFC; -webkit-tap-highlight-color: transparent; }
        
        /* Custom Scrollbar hide */
        .no-scrollbar::-webkit-scrollbar { display: none; }
        .no-scrollbar { -ms-overflow-style: none; scrollbar-width: none; }

        /* Animations */
        @keyframes spin { to { transform: rotate(360deg); } }
        .spinner { border: 3px solid #e2e8f0; border-top: 3px solid #10b981; border-radius: 50%; width: 20px; height: 20px; animation: spin 0.8s linear infinite; }
        
        @keyframes slideUp { from { transform: translateY(100%); opacity: 0; } to { transform: translateY(0); opacity: 1; } }
        .animate-slide-up { animation: slideUp 0.3s cubic-bezier(0.16, 1, 0.3, 1); }
        
        @keyframes fadeIn { from { opacity: 0; } to { opacity: 1; } }
        .animate-fade-in { animation: fadeIn 0.2s ease-out; }

        /* Modern Glass Effect */
        .glass { background: rgba(255, 255, 255, 0.7); backdrop-filter: blur(10px); -webkit-backdrop-filter: blur(10px); }
    </style>
</head>
<body class="text-slate-800 pb-24 md:pb-0">

    <?= $pesan ?>

    <nav class="hidden md:block sticky top-0 z-50 glass border-b border-slate-200/60">
        <div class="max-w-7xl mx-auto px-6 h-20 flex items-center justify-between">
            <div class="flex items-center gap-3">
                    <div class="w-10 h-10 rounded-xl shadow-lg shadow-emerald-600/20 overflow-hidden">
                        <img src="../icon.png" alt="Logo" class="w-full h-full object-cover">
                    </div>
                <div>
                    <h1 class="font-bold text-lg tracking-tight leading-none text-slate-900">Koperasi</h1>
                </div>
            </div>
            <div class="flex items-center gap-8">
                <div class="flex gap-1 bg-slate-100/50 p-1 rounded-full border border-slate-200">
                    <a href="index.php" class="px-4 py-2 bg-white rounded-full text-sm font-semibold text-emerald-700 shadow-sm border border-slate-100">Dashboard</a>
                    <a href="input_transaksi.php" class="px-4 py-2 rounded-full text-sm font-medium text-slate-600 hover:bg-slate-200/50 transition">Input</a>
                    <a href="anggota.php" class="px-4 py-2 rounded-full text-sm font-medium text-slate-600 hover:bg-slate-200/50 transition">Anggota</a>
                    <a href="riwayat.php" class="px-4 py-2 rounded-full text-sm font-medium text-slate-600 hover:bg-slate-200/50 transition">Riwayat</a>
                </div>
                <a href="?logout=true" onclick="confirmLogout(event)" class="text-slate-400 hover:text-rose-500 transition">
                    <i data-lucide="log-out" class="h-5 w-5"></i>
                </a>
            </div>
        </div>
    </nav>

    <div class="md:hidden pt-8 px-6 pb-2 flex justify-between items-center bg-[#F8FAFC]">
        <div>
            <p class="text-slate-500 text-xs font-medium mb-0.5">Selamat Pagi,</p>
            <h1 class="font-bold text-2xl text-slate-900 tracking-tight">Admin Koperasi</h1>
        </div>
        <div class="w-10 h-10 bg-white border border-slate-200 rounded-full flex items-center justify-center shadow-sm">
            <i data-lucide="bell" class="h-5 w-5 text-slate-600"></i>
        </div>
    </div>

    <main class="max-w-7xl mx-auto px-6 py-4 md:py-8">
        
        <div class="relative overflow-hidden rounded-[2.5rem] bg-slate-900 p-8 text-white shadow-2xl shadow-slate-900/20 mb-8">
            <div class="absolute -top-24 -right-24 h-64 w-64 rounded-full bg-emerald-500 opacity-20 blur-3xl"></div>
            <div class="absolute top-1/2 -left-24 h-48 w-48 rounded-full bg-teal-500 opacity-20 blur-3xl"></div>
            
            <div class="relative z-10">
                <p class="text-slate-400 font-medium text-sm mb-2">Total Aset Sukarela</p>
                <h2 class="text-4xl md:text-5xl font-extrabold tracking-tight mb-6">Rp <?= number_format($total_aset, 0, ',', '.') ?></h2>
                
                <div class="flex flex-wrap gap-3">
                    <a href="input_transaksi.php" class="flex-1 md:flex-none bg-emerald-500 hover:bg-emerald-400 text-white px-6 py-3.5 rounded-2xl font-bold text-sm transition flex items-center justify-center gap-2 shadow-lg shadow-emerald-500/25">
                        <i data-lucide="plus-circle" class="h-5 w-5"></i> Transaksi Baru
                    </a>
                    <button onclick="openMemberModal()" class="flex-1 md:flex-none bg-slate-800 hover:bg-slate-700 border border-slate-700 text-white px-6 py-3.5 rounded-2xl font-bold text-sm transition flex items-center justify-center gap-2">
                        <i data-lucide="user-plus" class="h-5 w-5"></i> Anggota
                    </button>
                </div>
            </div>
        </div>

        <div class="grid grid-cols-2 md:grid-cols-2 gap-4 md:gap-6 mb-8">
            <div class="bg-white p-5 rounded-3xl border border-slate-100 shadow-sm flex flex-col justify-between h-32 md:h-auto">
                <div class="flex items-start justify-between">
                    <div class="p-2.5 bg-emerald-50 rounded-2xl text-emerald-600">
                        <i data-lucide="arrow-down-left" class="h-6 w-6"></i>
                    </div>
                </div>
                <div>
                    <p class="text-xs text-slate-500 font-medium mb-1">Pemasukan (Bln Ini)</p>
                    <p class="text-lg md:text-xl font-bold text-slate-900">+ <?= number_format($masuk_bulan_ini, 0, ',', '.') ?></p>
                </div>
            </div>
            <div class="bg-white p-5 rounded-3xl border border-slate-100 shadow-sm flex flex-col justify-between h-32 md:h-auto">
                <div class="flex items-start justify-between">
                    <div class="p-2.5 bg-rose-50 rounded-2xl text-rose-600">
                        <i data-lucide="arrow-up-right" class="h-6 w-6"></i>
                    </div>
                </div>
                <div>
                    <p class="text-xs text-slate-500 font-medium mb-1">Pengeluaran (Bln Ini)</p>
                    <p class="text-lg md:text-xl font-bold text-slate-900">- <?= number_format($keluar_bulan_ini, 0, ',', '.') ?></p>
                </div>
            </div>
        </div>

        <div class="flex justify-between items-end mb-4">
            <h3 class="font-bold text-xl text-slate-900">Mutasi Terakhir</h3>
            <a href="riwayat.php" class="text-sm text-emerald-600 font-bold hover:underline">Lihat Semua</a>
        </div>

        <div class="bg-white rounded-3xl shadow-sm border border-slate-100 overflow-hidden">
            <div class="divide-y divide-slate-100">
                <?php
                $sql = "SELECT t.*, a.nama_lengkap FROM transaksi_sukarela t 
                        JOIN anggota a ON t.anggota_id = a.id 
                        ORDER BY t.created_at DESC LIMIT 5";
                $res = $conn->query($sql);
                
                if ($res->num_rows > 0) {
                    while($row = $res->fetch_assoc()) {
                        $is_masuk = ($row['jenis_transaksi'] == 'MASUK');
                        $color = $is_masuk ? 'text-emerald-600' : 'text-slate-900';
                        $icon_bg = $is_masuk ? 'bg-emerald-100 text-emerald-600' : 'bg-rose-100 text-rose-600';
                        $icon = $is_masuk ? 'arrow-down' : 'arrow-up';
                        $sign = $is_masuk ? '+' : '-';
                ?>
                <div class="p-5 flex items-center justify-between hover:bg-slate-50/80 transition">
                    <div class="flex items-center gap-4">
                        <div class="<?= $icon_bg ?> w-12 h-12 rounded-2xl flex items-center justify-center flex-shrink-0">
                            <i data-lucide="<?= $icon ?>" class="h-5 w-5"></i>
                        </div>
                        <div>
                            <p class="font-bold text-slate-900 text-sm md:text-base"><?= htmlspecialchars($row['nama_lengkap']) ?></p>
                            <p class="text-xs text-slate-500 mt-0.5"><?= date('d M, H:i', strtotime($row['created_at'])) ?> &bull; <?= $row['keterangan'] ?></p>
                        </div>
                    </div>
                    <div class="text-right">
                        <p class="font-bold <?= $color ?>"><?= $sign ?> <?= number_format($row['jumlah'],0,',','.') ?></p>
                        <p class="text-[10px] text-slate-400 font-medium">Sisa: <?= number_format($row['saldo_akhir'],0,',','.') ?></p>
                    </div>
                </div>
                <?php } } else { ?>
                    <div class="py-12 flex flex-col items-center justify-center text-slate-400">
                        <i data-lucide="clipboard-list" class="h-10 w-10 mb-3 opacity-50"></i>
                        <p class="text-sm">Belum ada transaksi</p>
                    </div>
                <?php } ?>
            </div>
        </div>

    </main>

    <div class="md:hidden fixed bottom-0 left-0 w-full z-50">
        <div class="absolute bottom-0 w-full h-24 bg-gradient-to-t from-white via-white/90 to-transparent pointer-events-none"></div>
        
        <div class="relative bg-white border-t border-slate-200 px-6 pb-6 pt-3 grid grid-cols-5 items-center">
            <a href="index.php" class="flex flex-col items-center justify-center gap-1 text-emerald-600">
                <i data-lucide="home" class="h-6 w-6 fill-current"></i>
                <span class="text-[10px] font-bold">Home</span>
            </a>
            
            <a href="anggota.php" class="flex flex-col items-center justify-center gap-1 text-slate-400 hover:text-emerald-600 transition">
                <i data-lucide="users" class="h-6 w-6"></i>
                <span class="text-[10px] font-medium">Anggota</span>
            </a>
            
            <div class="relative -top-6 flex justify-center">
                <a href="input_transaksi.php" class="w-14 h-14 bg-slate-900 rounded-full flex items-center justify-center text-white shadow-xl shadow-slate-900/30 border-4 border-white transform active:scale-95 transition">
                    <i data-lucide="plus" class="h-7 w-7"></i>
                </a>
            </div>

            <a href="riwayat.php" class="flex flex-col items-center justify-center gap-1 text-slate-400 hover:text-emerald-600 transition">
                <i data-lucide="history" class="h-6 w-6"></i>
                <span class="text-[10px] font-medium">Riwayat</span>
            </a>
            
            <a href="?logout=true" onclick="confirmLogout(event)" class="flex flex-col items-center justify-center gap-1 text-slate-400 hover:text-rose-500 transition">
                <i data-lucide="log-out" class="h-6 w-6"></i>
                <span class="text-[10px] font-medium">Keluar</span>
            </a>
        </div>
    </div>

    <div id="memberModal" class="fixed inset-0 bg-slate-900/60 hidden z-[60] backdrop-blur-sm items-end md:items-center justify-center transition-all duration-300">
        <div class="absolute inset-0" onclick="closeModals()"></div>

        <div class="bg-white w-full md:w-[480px] rounded-t-[2rem] md:rounded-[2rem] p-6 md:p-8 animate-slide-up md:animate-fade-in relative z-10 shadow-2xl">
            <div class="w-12 h-1.5 bg-slate-200 rounded-full mx-auto mb-6 md:hidden"></div>
            
            <div class="flex justify-between items-center mb-6">
                <div>
                    <h3 class="text-xl font-bold text-slate-900">Anggota Baru</h3>
                    <p class="text-sm text-slate-500">Daftarkan anggota koperasi baru</p>
                </div>
                <button onclick="closeModals()" class="p-2 bg-slate-100 rounded-full hover:bg-slate-200 transition">
                    <i data-lucide="x" class="h-5 w-5 text-slate-500"></i>
                </button>
            </div>

            <form method="POST" class="space-y-5">
                <input type="hidden" name="action" value="add_member">
                
                <div class="space-y-1.5">
                    <label class="text-sm font-semibold text-slate-700">Nama Lengkap</label>
                    <div class="relative">
                        <input type="text" name="nama" id="inputNama" required autocomplete="off" 
                               class="w-full pl-4 pr-10 py-4 bg-slate-50 border border-slate-200 rounded-2xl focus:ring-2 focus:ring-emerald-500 focus:bg-white focus:border-emerald-500 transition outline-none text-slate-800 placeholder-slate-400" 
                               placeholder="Contoh: Budi Santoso">
                        <div id="loadingIndicator" class="hidden absolute right-4 top-4">
                            <div class="spinner"></div>
                        </div>
                        <div id="statusIcon" class="hidden absolute right-4 top-4"></div>
                    </div>
                    <p id="feedbackNama" class="text-xs font-bold mt-1 ml-1 hidden"></p>
                </div>

                <div class="space-y-1.5">
                    <label class="text-sm font-semibold text-slate-700">Saldo Awal (Rp)</label>
                    <input type="text" name="saldo_awal" required onkeyup="formatRupiah(this)" 
                           class="w-full px-4 py-4 bg-slate-50 border border-slate-200 rounded-2xl focus:ring-2 focus:ring-emerald-500 focus:bg-white focus:border-emerald-500 transition outline-none text-slate-800 text-lg font-medium"
                           placeholder="0">
                </div>

                <div class="pt-2">
                    <button type="submit" id="btnSubmitAnggota" disabled 
                            class="w-full bg-slate-900 hover:bg-slate-800 text-white font-bold py-4 rounded-2xl shadow-lg shadow-slate-900/20 transition disabled:opacity-50 disabled:cursor-not-allowed">
                        Simpan Data
                    </button>
                </div>
            </form>
        </div>
    </div>

    <script>
        // Initialize Icons
        lucide.createIcons();

        // --- KONFIRMASI LOGOUT ---
        function confirmLogout(e) {
            e.preventDefault();
            const url = e.currentTarget.getAttribute('href');

            Swal.fire({
                title: 'Keluar Aplikasi?',
                text: "Sesi anda akan diakhiri.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#0f172a', // slate-900
                cancelButtonColor: '#e2e8f0',
                confirmButtonText: 'Ya, Keluar',
                cancelButtonText: '<span style="color:#64748b">Batal</span>', // slate-500
                background: '#fff',
                customClass: {
                    popup: 'rounded-3xl',
                    confirmButton: 'rounded-xl px-6 py-3',
                    cancelButton: 'rounded-xl px-6 py-3'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = url;
                }
            })
        }

        // --- FORMAT RUPIAH ---
        function formatRupiah(input) { 
            let value = input.value.replace(/\D/g, ''); 
            if (value.length > 0) value = value.replace(/\B(?=(\d{3})+(?!\d))/g, "."); 
            input.value = value; 
        }

        // --- MODAL CONTROLLER ---
        const memberModal = document.getElementById('memberModal');

        function openMemberModal() { 
            closeModals(); 
            memberModal.classList.remove('hidden'); 
            memberModal.classList.add('flex'); 
            document.body.style.overflow = 'hidden'; // Prevent scroll body
        }

        function closeModals() {
            memberModal.classList.add('hidden'); 
            memberModal.classList.remove('flex');
            document.body.style.overflow = 'auto'; // Restore scroll
            
            // Reset form visually
            const form = memberModal.querySelector('form');
            if(form) form.reset();
            resetFeedback();
        }
        
        function resetFeedback() {
            const feedback = document.getElementById('feedbackNama');
            const input = document.getElementById('inputNama');
            const btn = document.getElementById('btnSubmitAnggota');
            
            feedback.classList.add('hidden');
            input.classList.remove('border-rose-500', 'text-rose-600', 'border-emerald-500', 'text-emerald-600');
            btn.disabled = true;
        }

        // --- LIVE CHECK NAME (AJAX) ---
        const inputNama = document.getElementById('inputNama');
        const feedback = document.getElementById('feedbackNama');
        const btnSubmit = document.getElementById('btnSubmitAnggota');
        const loader = document.getElementById('loadingIndicator');
        let timeout = null;

        if (inputNama) {
            inputNama.addEventListener('input', function() {
                let val = this.value;
                resetFeedback(); // Reset state visuals
                
                if (val.length < 3) return; 

                clearTimeout(timeout);
                loader.classList.remove('hidden'); 
                
                timeout = setTimeout(() => {
                    let formData = new FormData();
                    formData.append('ajax_check_name', val);
                    
                    fetch('index.php', { method: 'POST', body: formData })
                    .then(r => r.text())
                    .then(status => {
                        loader.classList.add('hidden'); 
                        status = status.trim();
                        feedback.classList.remove('hidden');
                        
                        if (status === 'taken') {
                            feedback.innerHTML = "Nama sudah digunakan";
                            feedback.className = "text-xs font-bold mt-1 ml-1 text-rose-500 block";
                            inputNama.classList.add('border-rose-500', 'text-rose-600');
                            btnSubmit.disabled = true; 
                        } else {
                            feedback.innerHTML = "Nama tersedia";
                            feedback.className = "text-xs font-bold mt-1 ml-1 text-emerald-600 block";
                            inputNama.classList.add('border-emerald-500', 'text-emerald-600');
                            btnSubmit.disabled = false;
                        }
                    })
                    .catch(e => { console.error(e); loader.classList.add('hidden'); });
                }, 600); // Delay debounce
            });
        }
    </script>
</body>
</html>