<?php
session_start();
include '../config.php';

// --- SET TIMEZONE INDONESIA ---
date_default_timezone_set('Asia/Jakarta');

// --- FUNGSI FORMAT ANGKA ---
function clean_number($rupiah) {
    return preg_replace('/[^0-9]/', '', $rupiah);
}

// --- VARIABEL UNTUK JS ---
$trigger_success = false;
$receipt_data = [];

// --- LOGIC TRANSAKSI ---
$pesan = "";
if (isset($_POST['action']) && $_POST['action'] == 'transaction') {
    $anggota_id = $_POST['anggota_id'];
    $jenis      = $_POST['jenis_transaksi'];
    $jumlah     = clean_number($_POST['jumlah']);
    $tanggal    = $_POST['tanggal']; // Format: YYYY-MM-DD
    $keterangan = $_POST['keterangan'];

    // Validasi input
    if (empty($anggota_id) || empty($jumlah) || $jumlah <= 0) {
        $pesan = "<script>Swal.fire('Error', 'Pilih anggota dan masukkan nominal yang benar!', 'error');</script>";
    } else {
        $res = $conn->query("SELECT * FROM anggota WHERE id = $anggota_id");
        if ($res->num_rows > 0) {
            $row = $res->fetch_assoc();
            $saldo_lama = $row['saldo_akhir'];
            $nama_anggota = $row['nama_lengkap']; 
            $no_anggota = $row['nomor_anggota'];  
            
            $saldo_baru = 0;
            $valid = true;

            if ($jenis == 'MASUK') {
                $saldo_baru = $saldo_lama + $jumlah;
            } else {
                if ($saldo_lama >= $jumlah) {
                    $saldo_baru = $saldo_lama - $jumlah;
                } else {
                    $valid = false;
                    $pesan = "<script>document.addEventListener('DOMContentLoaded', function() { Swal.fire({icon: 'warning', title: 'Saldo Tidak Cukup', text: 'Sisa saldo member: Rp ".number_format($saldo_lama)."'}); });</script>";
                }
            }

            if ($valid) {
                $stmt = $conn->prepare("INSERT INTO transaksi_sukarela (anggota_id, jenis_transaksi, jumlah, saldo_akhir, keterangan, tanggal_transaksi) VALUES (?, ?, ?, ?, ?, ?)");
                $stmt->bind_param("isddss", $anggota_id, $jenis, $jumlah, $saldo_baru, $keterangan, $tanggal);
                $conn->query("UPDATE anggota SET saldo_akhir = $saldo_baru WHERE id = $anggota_id");
                
                if ($stmt->execute()) {
                    // --- DATA UNTUK STRUK FOTO (DENGAN JAM) ---
                    $trigger_success = true;
                    
                    // Gabungkan Tanggal Input User + Jam Sekarang (Realtime)
                    $jam_sekarang = date('H:i'); 
                    $tgl_formatted = date('d/m/Y', strtotime($tanggal)) . ' ' . $jam_sekarang;

                    $receipt_data = [
                        'tanggal_jam' => $tgl_formatted, // Ini yang akan ditampilkan di struk
                        'no_transaksi' => 'TRX-' . time(),
                        'nama' => $nama_anggota,
                        'nomor_anggota' => $no_anggota,
                        'jenis' => ($jenis == 'MASUK') ? 'SETORAN SUKARELA' : 'PENARIKAN TUNAI',
                        'jumlah' => "Rp " . number_format($jumlah, 0, ',', '.'),
                        'saldo_akhir' => "Rp " . number_format($saldo_baru, 0, ',', '.'),
                        'keterangan' => $keterangan ?: '-'
                    ];
                }
            }
        } else {
            $pesan = "<script>Swal.fire('Error', 'Anggota tidak valid', 'error');</script>";
        }
    }
}

// --- AMBIL DATA ANGGOTA KE ARRAY PHP ---
$data_anggota = [];
$query = $conn->query("SELECT * FROM anggota ORDER BY nama_lengkap ASC");
while ($row = $query->fetch_assoc()) {
    $data_anggota[] = $row;
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Input Transaksi</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/lucide@latest"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://html2canvas.hertzen.com/dist/html2canvas.min.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@300;400;500;600;700;800&family=Courier+Prime:wght@400;700&display=swap" rel="stylesheet">
    
    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; background-color: #F8FAFC; -webkit-tap-highlight-color: transparent; }
        .glass { background: rgba(255, 255, 255, 0.7); backdrop-filter: blur(10px); -webkit-backdrop-filter: blur(10px); }
        .type-btn.active { background-color: white; box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06); }
        .transition-all { transition-property: all; transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1); transition-duration: 300ms; }
        
        #searchDropdown { scrollbar-width: thin; scrollbar-color: #cbd5e1 transparent; }
        #searchDropdown::-webkit-scrollbar { width: 6px; }
        #searchDropdown::-webkit-scrollbar-thumb { background-color: #cbd5e1; border-radius: 20px; }

        /* Style Struk Tersembunyi */
        .receipt-font { font-family: 'Courier Prime', monospace; }
        #receipt-container {
            position: fixed;
            top: -9999px;
            left: -9999px;
            z-index: -10;
        }
    </style>
</head>
<body class="text-slate-800 pb-24 md:pb-0">
    <?= $pesan ?>

    <div id="receipt-container">
        <div id="receipt-area" class="w-[400px] bg-white p-8 border border-gray-200 receipt-font text-slate-900 relative">
            <div class="absolute inset-x-0 top-0 h-2 bg-[url('data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTAiIGhlaWdodD0iMTAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PGNpcmNsZSBjeD0iNSIgY3k9IjUiIHI9IjIiIGZpbGw9IiNjYmQ1ZTEiLz48L3N2Zz4=')] opacity-50"></div>
            
            <div class="text-center mb-6">
                <h2 class="text-2xl font-bold uppercase tracking-wider mb-1">Koperasi PSHT Curug</h2>
                <p class="text-xs text-gray-500">Bukti Transaksi Digital</p>
                <div class="my-4 border-b-2 border-dashed border-gray-300"></div>
            </div>

            <div class="space-y-3 text-sm">
                <div class="flex justify-between">
                    <span class="text-gray-500">Waktu</span>
                    <span class="font-bold" id="rec_waktu"></span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500">No. Reff</span>
                    <span class="font-bold" id="rec_reff"></span>
                </div>
                <div class="my-2 border-b border-dashed border-gray-300"></div>
                
                <div class="flex justify-between">
                    <span class="text-gray-500">Anggota</span>
                    <span class="font-bold text-right w-1/2 break-words" id="rec_nama"></span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500">ID Anggota</span>
                    <span class="font-bold" id="rec_id"></span>
                </div>
                 <div class="flex justify-between">
                    <span class="text-gray-500">Jenis</span>
                    <span class="font-bold uppercase" id="rec_jenis"></span>
                </div>
                
                <div class="my-4 border-b-2 border-dashed border-gray-300"></div>

                <div class="flex justify-between items-center py-2">
                    <span class="text-lg font-bold">TOTAL</span>
                    <span class="text-xl font-bold" id="rec_jumlah"></span>
                </div>

                <div class="my-2 border-b border-dashed border-gray-300"></div>
                
                <div class="flex justify-between text-xs">
                    <span class="text-gray-500">Saldo Akhir</span>
                    <span class="font-bold" id="rec_saldo"></span>
                </div>
                <div class="flex justify-between text-xs mt-1">
                    <span class="text-gray-500">Ket</span>
                    <span class="font-bold italic" id="rec_ket"></span>
                </div>
            </div>

            <div class="mt-8 text-center text-[10px] text-gray-400">
                <p>Terima kasih telah bertransaksi</p>
                <p class="mt-1">Simpan bukti ini sebagai referensi yang sah.</p>
            </div>
            
            <div class="absolute inset-x-0 bottom-0 h-2 bg-[url('data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTAiIGhlaWdodD0iMTAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PGNpcmNsZSBjeD0iNSIgY3k9IjUiIHI9IjIiIGZpbGw9IiNjYmQ1ZTEiLz48L3N2Zz4=')] opacity-50"></div>
        </div>
    </div>

    <nav class="hidden md:block sticky top-0 z-50 glass border-b border-slate-200/60">
        <div class="max-w-7xl mx-auto px-6 h-20 flex items-center justify-between">
            <div class="flex items-center gap-3">
                    <div class="w-10 h-10 rounded-xl shadow-lg shadow-emerald-600/20 overflow-hidden">
                        <img src="../icon.png" alt="Logo" class="w-full h-full object-cover">
                    </div>
                <div><h1 class="font-bold text-lg text-slate-900">Koperasi</h1>
                </div>
            </div>
            <div class="flex items-center gap-8">
                <div class="flex gap-1 bg-slate-100/50 p-1 rounded-full border border-slate-200">
                    <a href="index.php" class="px-4 py-2 rounded-full text-sm font-medium text-slate-600 hover:bg-slate-200/50 transition">Dashboard</a>
                    <a href="input_transaksi.php" class="px-4 py-2 bg-white rounded-full text-sm font-semibold text-emerald-700 shadow-sm border border-slate-100">Input</a>
                    <a href="anggota.php" class="px-4 py-2 rounded-full text-sm font-medium text-slate-600 hover:bg-slate-200/50 transition">Anggota</a>
                    <a href="riwayat.php" class="px-4 py-2 rounded-full text-sm font-medium text-slate-600 hover:bg-slate-200/50 transition">Riwayat</a>
                </div>
                <a href="index.php?logout=true" onclick="confirmLogout(event)" class="text-slate-400 hover:text-rose-500 transition"><i data-lucide="log-out" class="h-5 w-5"></i></a>
            </div>
        </div>
    </nav>

    <div class="md:hidden pt-6 px-6 pb-2">
        <a href="index.php" class="inline-flex items-center gap-2 text-slate-500 hover:text-slate-800 mb-4 transition">
            <i data-lucide="arrow-left" class="h-5 w-5"></i><span class="font-medium text-sm">Kembali</span>
        </a>
        <h1 class="font-bold text-2xl text-slate-900 tracking-tight">Input Transaksi</h1>
    </div>

    <main class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8 py-4 md:py-10">
        <form method="POST" id="transaksiForm" autocomplete="off" class="space-y-6 md:bg-white md:p-8 md:rounded-[2rem] md:shadow-xl md:shadow-slate-200/50 md:border md:border-slate-100">
            <input type="hidden" name="action" value="transaction">
            <input type="hidden" name="jenis_transaksi" id="jenisTransaksi" value="MASUK">

            <div class="bg-slate-100 p-1.5 rounded-2xl grid grid-cols-2 gap-2 relative">
                <button type="button" onclick="setTxType('MASUK')" id="btnMasuk" class="type-btn active py-3 rounded-xl text-sm font-bold flex items-center justify-center gap-2 transition-all text-emerald-700">
                    <i data-lucide="arrow-down-circle" class="h-5 w-5"></i> Setor Tunai
                </button>
                <button type="button" onclick="setTxType('KELUAR')" id="btnKeluar" class="type-btn py-3 rounded-xl text-sm font-bold flex items-center justify-center gap-2 transition-all text-slate-500">
                    <i data-lucide="arrow-up-circle" class="h-5 w-5"></i> Tarik Tunai
                </button>
            </div>

            <div class="space-y-1.5 relative">
                <label class="text-sm font-semibold text-slate-700 ml-1">Cari Anggota</label>
                <div class="relative">
                    <input type="hidden" name="anggota_id" id="anggotaId" required>
                    <input type="text" id="memberSearch" placeholder="Ketik nama anggota..." 
                           class="w-full pl-4 pr-10 py-4 bg-white border border-slate-200 rounded-2xl focus:ring-2 focus:ring-emerald-500 focus:border-emerald-500 transition outline-none text-slate-800 shadow-sm"
                           oninput="filterMembers()" onfocus="filterMembers()">
                    <div class="absolute inset-y-0 right-4 flex items-center text-slate-400 pointer-events-none">
                        <i data-lucide="search" class="h-5 w-5"></i>
                    </div>
                    <div id="searchDropdown" class="hidden absolute w-full bg-white border border-slate-200 rounded-xl mt-2 shadow-xl max-h-60 overflow-y-auto z-50 divide-y divide-slate-50"></div>
                </div>
            </div>

            <div id="infoCard" class="hidden animate-slide-up bg-slate-50 border border-slate-200 rounded-2xl p-5 flex items-center justify-between">
                <div>
                    <p class="text-xs text-slate-500 font-semibold uppercase tracking-wider mb-1">Saldo Saat Ini</p>
                    <p id="displaySaldo" class="text-2xl font-extrabold text-slate-900">Rp 0</p>
                </div>
                <div class="h-12 w-12 rounded-full bg-white border border-slate-200 flex items-center justify-center">
                    <i data-lucide="wallet" class="h-6 w-6 text-slate-400"></i>
                </div>
            </div>

            <div class="space-y-1.5">
                <label class="text-sm font-semibold text-slate-700 ml-1">Nominal (Rp)</label>
                <div class="relative">
                    <span class="absolute left-5 top-1/2 -translate-y-1/2 font-bold text-slate-400">Rp</span>
                    <input type="text" name="jumlah" id="jumlahInput" required onkeyup="formatRupiah(this); validateSaldo()" 
                           class="w-full pl-12 pr-4 py-4 bg-white border border-slate-200 rounded-2xl focus:ring-2 focus:ring-emerald-500 transition outline-none text-slate-900 text-xl font-bold placeholder-slate-300 shadow-sm" 
                           placeholder="0">
                </div>
                <p id="errorMsg" class="text-rose-500 text-xs font-bold ml-1 hidden mt-2 flex items-center gap-1">
                    <i data-lucide="alert-circle" class="h-3 w-3"></i> Nominal melebihi saldo tersedia!
                </p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div class="space-y-1.5">
                    <label class="text-sm font-semibold text-slate-700 ml-1">Tanggal</label>
                    <input type="date" name="tanggal" value="<?= date('Y-m-d') ?>" required
                           class="w-full px-4 py-4 bg-white border border-slate-200 rounded-2xl focus:ring-2 focus:ring-emerald-500 transition outline-none text-slate-800 shadow-sm">
                </div>
                <div class="space-y-1.5">
                    <label class="text-sm font-semibold text-slate-700 ml-1">Catatan</label>
                    <input type="text" name="keterangan" placeholder="Opsional..."
                           class="w-full px-4 py-4 bg-white border border-slate-200 rounded-2xl focus:ring-2 focus:ring-emerald-500 transition outline-none text-slate-800 shadow-sm">
                </div>
            </div>

            <div class="pt-4">
                <button type="submit" id="btnSubmit" class="w-full bg-emerald-600 hover:bg-emerald-500 text-white font-bold py-4 rounded-2xl shadow-lg shadow-emerald-600/30 transition transform active:scale-95 flex justify-center items-center gap-2">
                    <i data-lucide="check-circle" class="h-5 w-5"></i>
                    <span>Konfirmasi Setoran</span>
                </button>
            </div>
        </form>
    </main>

    <div class="md:hidden fixed bottom-0 left-0 w-full z-50">
        <div class="absolute bottom-0 w-full h-24 bg-gradient-to-t from-white via-white/90 to-transparent pointer-events-none"></div>
        <div class="relative bg-white border-t border-slate-200 px-6 pb-6 pt-3 grid grid-cols-5 items-center">
            <a href="index.php" class="flex flex-col items-center justify-center gap-1 text-slate-400 hover:text-emerald-600">
                <i data-lucide="home" class="h-6 w-6"></i><span class="text-[10px] font-medium">Home</span>
            </a>
            <a href="anggota.php" class="flex flex-col items-center justify-center gap-1 text-slate-400 hover:text-emerald-600">
                <i data-lucide="users" class="h-6 w-6"></i><span class="text-[10px] font-medium">Anggota</span>
            </a>
            <div class="relative -top-6 flex justify-center">
                <a href="input_transaksi.php" class="w-14 h-14 bg-slate-900 rounded-full flex items-center justify-center text-white shadow-xl shadow-slate-900/30 border-4 border-white">
                    <i data-lucide="plus" class="h-7 w-7"></i>
                </a>
            </div>
            <a href="riwayat.php" class="flex flex-col items-center justify-center gap-1 text-slate-400 hover:text-emerald-600">
                <i data-lucide="history" class="h-6 w-6"></i><span class="text-[10px] font-medium">Riwayat</span>
            </a>
            <a href="index.php?logout=true" onclick="confirmLogout(event)" class="flex flex-col items-center justify-center gap-1 text-slate-400 hover:text-rose-500">
                <i data-lucide="log-out" class="h-6 w-6"></i><span class="text-[10px] font-medium">Keluar</span>
            </a>
        </div>
    </div>

    <script>
        lucide.createIcons();
        const membersData = <?= json_encode($data_anggota) ?>;
        
        // --- LOGIC SUKSES TRANSAKSI & DOWNLOAD GAMBAR (UPDATED) ---
        <?php if ($trigger_success): ?>
            document.addEventListener('DOMContentLoaded', function() {
                // 1. Isi Data ke Template Struk (Termasuk Jam)
                const data = <?= json_encode($receipt_data) ?>;
                
                // MENGISI DATA TANGGAL + JAM
                document.getElementById('rec_waktu').innerText = data.tanggal_jam; // Updated ID
                
                document.getElementById('rec_reff').innerText = data.no_transaksi;
                document.getElementById('rec_nama').innerText = data.nama;
                document.getElementById('rec_id').innerText = data.nomor_anggota;
                document.getElementById('rec_jenis').innerText = data.jenis;
                document.getElementById('rec_jumlah').innerText = data.jumlah;
                document.getElementById('rec_saldo').innerText = data.saldo_akhir;
                document.getElementById('rec_ket').innerText = data.keterangan;

                // 2. Tampilkan SweetAlert
                Swal.fire({
                    icon: 'success',
                    title: 'Transaksi Berhasil',
                    html: `
                        <p class="mb-4">Saldo Baru: <b>${data.saldo_akhir}</b></p>
                        <p class="text-sm text-gray-500">Klik tombol di bawah untuk menyimpan bukti.</p>
                    `,
                    showDenyButton: true,
                    confirmButtonText: '<i class="fa fa-download"></i> Download Bukti (JPG)',
                    denyButtonText: 'Tutup',
                    confirmButtonColor: '#059669', 
                    denyButtonColor: '#64748b',   
                    allowOutsideClick: false
                }).then((result) => {
                    if (result.isConfirmed) {
                        const element = document.getElementById("receipt-area");
                        html2canvas(element, { 
                            scale: 2, 
                            backgroundColor: "#ffffff"
                        }).then(canvas => {
                            const link = document.createElement('a');
                            link.download = 'Bukti_' + data.no_transaksi + '.jpg';
                            link.href = canvas.toDataURL("image/jpeg", 0.9);
                            link.click();
                            setTimeout(() => { window.location = 'input_transaksi.php'; }, 1000);
                        });
                    } else {
                         window.location = 'input_transaksi.php';
                    }
                });
            });
        <?php endif; ?>

        // --- SEARCHABLE DROPDOWN & LOGIC LAINNYA (SAMA SEPERTI SEBELUMNYA) ---
        const searchInput = document.getElementById('memberSearch');
        const dropdown = document.getElementById('searchDropdown');
        const hiddenId = document.getElementById('anggotaId');
        const infoCard = document.getElementById('infoCard');
        const displaySaldo = document.getElementById('displaySaldo');
        let currentSaldo = 0;

        function filterMembers() {
            const query = searchInput.value.toLowerCase();
            dropdown.innerHTML = '';
            const filtered = membersData.filter(member => 
                member.nama_lengkap.toLowerCase().includes(query) || 
                member.nomor_anggota.toLowerCase().includes(query)
            );

            if (filtered.length > 0) {
                dropdown.classList.remove('hidden');
                filtered.forEach(member => {
                    const div = document.createElement('div');
                    div.className = 'p-3 hover:bg-emerald-50 cursor-pointer transition flex justify-between items-center group';
                    div.innerHTML = `
                        <div>
                            <p class="font-bold text-slate-800 group-hover:text-emerald-700">${member.nama_lengkap}</p>
                            <p class="text-xs text-slate-500">${member.nomor_anggota}</p>
                        </div>
                        <div class="text-right">
                            <span class="text-[10px] text-slate-400">Saldo</span>
                            <p class="text-xs font-bold text-slate-600">Rp ${parseInt(member.saldo_akhir).toLocaleString('id-ID')}</p>
                        </div>
                    `;
                    div.onclick = () => selectMember(member);
                    dropdown.appendChild(div);
                });
            } else {
                dropdown.innerHTML = `<div class="p-3 text-sm text-slate-400 text-center">Tidak ditemukan</div>`;
                dropdown.classList.remove('hidden');
            }
        }

        function selectMember(member) {
            searchInput.value = member.nama_lengkap;
            hiddenId.value = member.id;
            currentSaldo = parseInt(member.saldo_akhir);
            displaySaldo.textContent = 'Rp ' + currentSaldo.toLocaleString('id-ID');
            infoCard.classList.remove('hidden');
            dropdown.classList.add('hidden');
            validateSaldo();
        }

        document.addEventListener('click', function(e) {
            if (!searchInput.contains(e.target) && !dropdown.contains(e.target)) {
                dropdown.classList.add('hidden');
            }
        });

        let currentType = 'MASUK';
        function setTxType(type) {
            currentType = type;
            document.getElementById('jenisTransaksi').value = type;
            const btnMasuk = document.getElementById('btnMasuk');
            const btnKeluar = document.getElementById('btnKeluar');
            const submitBtn = document.getElementById('btnSubmit');
            const submitText = submitBtn.querySelector('span');

            btnMasuk.className = "type-btn py-3 rounded-xl text-sm font-bold flex items-center justify-center gap-2 transition-all text-slate-500 hover:text-slate-700";
            btnKeluar.className = "type-btn py-3 rounded-xl text-sm font-bold flex items-center justify-center gap-2 transition-all text-slate-500 hover:text-slate-700";

            if (type === 'MASUK') {
                btnMasuk.classList.add('active', 'text-emerald-700');
                btnMasuk.classList.remove('text-slate-500');
                submitBtn.className = "w-full bg-emerald-600 hover:bg-emerald-500 text-white font-bold py-4 rounded-2xl shadow-lg shadow-emerald-600/30 transition transform active:scale-95 flex justify-center items-center gap-2";
                submitText.textContent = "Konfirmasi Setoran";
            } else {
                btnKeluar.classList.add('active', 'text-rose-700');
                btnKeluar.classList.remove('text-slate-500');
                submitBtn.className = "w-full bg-rose-600 hover:bg-rose-500 text-white font-bold py-4 rounded-2xl shadow-lg shadow-rose-600/30 transition transform active:scale-95 flex justify-center items-center gap-2";
                submitText.textContent = "Konfirmasi Penarikan";
            }
            validateSaldo();
        }

        function formatRupiah(input) { 
            let value = input.value.replace(/\D/g, ''); 
            if (value.length > 0) value = value.replace(/\B(?=(\d{3})+(?!\d))/g, "."); 
            input.value = value; 
        }

        function validateSaldo() {
            const input = document.getElementById('jumlahInput');
            const errorMsg = document.getElementById('errorMsg');
            const btn = document.getElementById('btnSubmit');
            const nominal = parseInt(input.value.replace(/\./g, '') || 0);

            if (currentType === 'KELUAR' && nominal > currentSaldo) {
                input.classList.add('border-rose-500', 'text-rose-600', 'focus:ring-rose-500');
                input.classList.remove('border-slate-200', 'text-slate-900', 'focus:ring-emerald-500');
                errorMsg.classList.remove('hidden');
                btn.disabled = true;
                btn.classList.add('opacity-50', 'cursor-not-allowed');
            } else {
                input.classList.remove('border-rose-500', 'text-rose-600', 'focus:ring-rose-500');
                input.classList.add('border-slate-200', 'text-slate-900', 'focus:ring-emerald-500');
                errorMsg.classList.add('hidden');
                btn.disabled = false;
                btn.classList.remove('opacity-50', 'cursor-not-allowed');
            }
        }

        function confirmLogout(e) {
            e.preventDefault();
            const url = e.currentTarget.getAttribute('href');
            Swal.fire({
                title: 'Keluar?',
                text: "Anda harus login ulang.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#0f172a',
                cancelButtonColor: '#e2e8f0',
                confirmButtonText: 'Ya',
                cancelButtonText: '<span style="color:#64748b">Batal</span>',
                customClass: { popup: 'rounded-3xl', confirmButton: 'rounded-xl', cancelButton: 'rounded-xl' }
            }).then((result) => {
                if (result.isConfirmed) window.location.href = url;
            })
        }
    </script>
</body>
</html>