<?php
session_start();
include '../config.php';

// Fungsi bantu untuk simpan pesan ke session
function set_notif($type, $title, $text) {
    $_SESSION['notif'] = ['type' => $type, 'title' => $title, 'text' => $text];
}

// --- 1. LOGIKA TAMBAH ANGGOTA BARU ---
if (isset($_POST['action']) && $_POST['action'] == 'add_member') {
    $nama = mysqli_real_escape_string($conn, $_POST['nama']);
    $saldo_awal = str_replace('.', '', $_POST['saldo_awal']); 
    
    // Cek nama ganda
    $cek = $conn->query("SELECT id FROM anggota WHERE nama_lengkap = '$nama'");
    if ($cek->num_rows > 0) {
        set_notif('error', 'Gagal', 'Nama anggota sudah terdaftar!');
    } else {
        $no_anggota = "AG" . rand(1000, 9999);
        $stmt = $conn->prepare("INSERT INTO anggota (nama_lengkap, nomor_anggota, saldo_akhir) VALUES (?, ?, ?)");
        $stmt->bind_param("ssd", $nama, $no_anggota, $saldo_awal);
        
        if ($stmt->execute()) {
            $new_id = $stmt->insert_id;
            if ($saldo_awal > 0) {
                $conn->query("INSERT INTO transaksi_sukarela (anggota_id, jenis_transaksi, jumlah, saldo_akhir, keterangan, created_at) 
                              VALUES ($new_id, 'MASUK', $saldo_awal, $saldo_awal, 'Saldo Awal', NOW())");
            }
            set_notif('success', 'Berhasil', "Anggota $no_anggota berhasil didaftarkan.");
        }
    }
    header("Location: riwayat.php");
    exit();
}

// --- 2. LOGIKA INPUT TRANSAKSI BARU ---
if (isset($_POST['action']) && $_POST['action'] == 'transaction') {
    // (Logika transaksi sama seperti sebelumnya, disesuaikan dengan keamanan)
    // ... Implementasi ringkas untuk mempersingkat kode tampilan ...
    // Pastikan menggunakan prepared statement di produksi
}

// --- 3. LOGIKA HAPUS & ROLLBACK (PENTING) ---
if (isset($_GET['hapus'])) {
    $id_transaksi = $_GET['hapus'];
    
    // Ambil data transaksi sebelum dihapus untuk rollback saldo
    $cek = $conn->query("SELECT * FROM transaksi_sukarela WHERE id = '$id_transaksi'");
    
    if ($cek->num_rows > 0) {
        $data = $cek->fetch_assoc();
        $id_anggota = $data['anggota_id'];
        $jumlah = $data['jumlah'];
        $jenis = $data['jenis_transaksi'];
        
        // Rollback Saldo: Jika tadinya MASUK, maka dikurangi. Jika KELUAR, maka ditambah.
        if ($jenis == 'MASUK') {
            $sql_update = "UPDATE anggota SET saldo_akhir = saldo_akhir - $jumlah WHERE id = $id_anggota";
        } else {
            $sql_update = "UPDATE anggota SET saldo_akhir = saldo_akhir + $jumlah WHERE id = $id_anggota";
        }
        
        $conn->begin_transaction();
        try {
            $conn->query($sql_update);
            $conn->query("DELETE FROM transaksi_sukarela WHERE id = '$id_transaksi'");
            $conn->commit();
            set_notif('success', 'Dibatalkan', 'Transaksi dihapus dan saldo dikembalikan.');
        } catch (Exception $e) {
            $conn->rollback();
            set_notif('error', 'Gagal', 'Terjadi kesalahan saat membatalkan transaksi.');
        }
        header("Location: riwayat.php");
        exit();
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Riwayat Transaksi</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/lucide@latest"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; background-color: #F8FAFC; -webkit-tap-highlight-color: transparent; }
        .glass { background: rgba(255, 255, 255, 0.7); backdrop-filter: blur(10px); -webkit-backdrop-filter: blur(10px); }
        .no-scrollbar::-webkit-scrollbar { display: none; }
        
        /* Animation Classes */
        @keyframes slideUp { from { transform: translateY(100%); opacity: 0; } to { transform: translateY(0); opacity: 1; } }
        .animate-slide-up { animation: slideUp 0.3s cubic-bezier(0.16, 1, 0.3, 1); }
        
        @keyframes fadeIn { from { opacity: 0; } to { opacity: 1; } }
        .animate-fade-in { animation: fadeIn 0.2s ease-out; }
    </style>
</head>
<body class="text-slate-800 pb-24 md:pb-0">

    <nav class="hidden md:block sticky top-0 z-50 glass border-b border-slate-200/60">
        <div class="max-w-7xl mx-auto px-6 h-20 flex items-center justify-between">
            <div class="flex items-center gap-3">
                    <div class="w-10 h-10 rounded-xl shadow-lg shadow-emerald-600/20 overflow-hidden">
                        <img src="../icon.png" alt="Logo" class="w-full h-full object-cover">
                    </div>
                <div>
                    <h1 class="font-bold text-lg tracking-tight leading-none text-slate-900">Koperasi</h1>
                </div>
            </div>
            <div class="flex items-center gap-8">
                <div class="flex gap-1 bg-slate-100/50 p-1 rounded-full border border-slate-200">
                    <a href="index.php" class="px-4 py-2 rounded-full text-sm font-medium text-slate-600 hover:bg-slate-200/50 transition">Dashboard</a>
                    <a href="input_transaksi.php" class="px-4 py-2 rounded-full text-sm font-medium text-slate-600 hover:bg-slate-200/50 transition">Input</a>
                    <a href="anggota.php" class="px-4 py-2 rounded-full text-sm font-medium text-slate-600 hover:bg-slate-200/50 transition">Anggota</a>
                    <a href="riwayat.php" class="px-4 py-2 bg-white rounded-full text-sm font-semibold text-emerald-700 shadow-sm border border-slate-100">Riwayat</a>
                </div>
                <button onclick="confirmLogout()" class="text-slate-400 hover:text-rose-500 transition">
                    <i data-lucide="log-out" class="h-5 w-5"></i>
                </button>
            </div>
        </div>
    </nav>

    <div class="md:hidden pt-6 px-6 pb-2">
        <a href="index.php" class="inline-flex items-center gap-2 text-slate-500 hover:text-slate-800 mb-4 transition">
            <i data-lucide="arrow-left" class="h-5 w-5"></i>
            <span class="font-medium text-sm">Kembali</span>
        </a>
        <h1 class="font-bold text-2xl text-slate-900 tracking-tight">Riwayat Mutasi</h1>
        <p class="text-slate-500 text-sm mt-1">Daftar transaksi masuk dan keluar.</p>
    </div>

    <main class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-4 md:py-8">
        
        <div class="bg-white rounded-[2rem] shadow-sm border border-slate-100 overflow-hidden">
            
            <div class="hidden md:grid grid-cols-6 bg-slate-50/80 p-5 text-xs font-bold text-slate-500 uppercase tracking-wider border-b border-slate-100 backdrop-blur-sm">
                <div class="col-span-2 pl-2">Anggota</div>
                <div>Tanggal</div>
                <div class="text-right pr-4">Nominal</div>
                <div class="text-right pr-4">Saldo Akhir</div>
                <div class="text-center">Aksi</div>
            </div>

            <div class="divide-y divide-slate-100">
                <?php
                $sql = "SELECT t.*, a.nama_lengkap, a.nomor_anggota FROM transaksi_sukarela t 
                        JOIN anggota a ON t.anggota_id = a.id 
                        ORDER BY t.created_at DESC LIMIT 50";
                $res = $conn->query($sql);
                
                if ($res->num_rows > 0) {
                    while($row = $res->fetch_assoc()) {
                        $is_masuk = ($row['jenis_transaksi'] == 'MASUK');
                        $color = $is_masuk ? 'text-emerald-600' : 'text-slate-900';
                        $icon_bg = $is_masuk ? 'bg-emerald-100 text-emerald-600' : 'bg-rose-100 text-rose-600';
                        $icon = $is_masuk ? 'arrow-down-left' : 'arrow-up-right';
                        $sign = $is_masuk ? '+' : '-';
                ?>
                <div class="group p-5 md:grid md:grid-cols-6 md:items-center hover:bg-slate-50/80 transition relative">
                    
                    <div class="flex items-center gap-4 md:col-span-2">
                        <div class="md:hidden <?= $icon_bg ?> w-12 h-12 rounded-2xl flex items-center justify-center flex-shrink-0">
                            <i data-lucide="<?= $icon ?>" class="h-5 w-5"></i>
                        </div>
                        <div class="hidden md:flex <?= $icon_bg ?> w-10 h-10 rounded-xl items-center justify-center flex-shrink-0">
                            <i data-lucide="<?= $icon ?>" class="h-5 w-5"></i>
                        </div>
                        <div class="overflow-hidden">
                            <p class="font-bold text-slate-900 text-base md:text-sm truncate"><?= htmlspecialchars($row['nama_lengkap']) ?></p>
                            <p class="text-xs text-slate-500 mt-0.5 md:hidden">
                                <?= $row['jenis_transaksi'] ?> • <?= date('d M Y', strtotime($row['created_at'])) ?>
                            </p>
                            <p class="hidden md:block text-xs text-slate-400 font-mono"><?= $row['nomor_anggota'] ?></p>
                        </div>
                    </div>

                    <div class="hidden md:block text-sm text-slate-500 font-medium">
                        <?= date('d M Y, H:i', strtotime($row['created_at'])) ?>
                        <span class="block text-[10px] <?= $is_masuk ? 'text-emerald-600' : 'text-rose-600' ?> font-bold uppercase mt-1"><?= $row['jenis_transaksi'] ?></span>
                    </div>

                    <div class="flex justify-between items-center mt-3 md:mt-0 md:contents">
                        <div class="md:text-right md:col-span-1 md:pr-4">
                            <p class="font-bold text-sm md:text-base <?= $color ?>"><?= $sign ?> Rp <?= number_format($row['jumlah'],0,',','.') ?></p>
                        </div>
                        <div class="md:text-right md:col-span-1 md:pr-4">
                            <span class="text-xs text-slate-400 md:hidden">Sisa Saldo: </span>
                            <p class="text-xs md:text-sm font-medium text-slate-500">Rp <?= number_format($row['saldo_akhir'],0,',','.') ?></p>
                        </div>
                    </div>

                    <div class="absolute top-5 right-5 md:static md:col-span-1 flex justify-end md:justify-center">
                        <button onclick="confirmDeleteTrx(<?= $row['id'] ?>)" 
                                class="p-2 text-slate-300 hover:text-rose-500 hover:bg-rose-50 rounded-xl transition-all"
                                title="Batalkan Transaksi">
                            <i data-lucide="trash-2" class="h-5 w-5"></i>
                        </button>
                    </div>

                </div>
                <?php } } else { ?>
                    <div class="py-20 flex flex-col items-center justify-center text-slate-400">
                        <i data-lucide="clipboard-list" class="h-16 w-16 mb-4 opacity-20"></i>
                        <p>Belum ada riwayat transaksi.</p>
                    </div>
                <?php } ?>
            </div>
        </div>

    </main>

    <div class="md:hidden fixed bottom-0 left-0 w-full z-50">
        <div class="absolute bottom-0 w-full h-24 bg-gradient-to-t from-white via-white/90 to-transparent pointer-events-none"></div>
        <div class="relative bg-white border-t border-slate-200 px-6 pb-6 pt-3 grid grid-cols-5 items-center">
            <a href="index.php" class="flex flex-col items-center justify-center gap-1 text-slate-400 hover:text-emerald-600 transition">
                <i data-lucide="home" class="h-6 w-6"></i>
                <span class="text-[10px] font-medium">Home</span>
            </a>
            <a href="anggota.php" class="flex flex-col items-center justify-center gap-1 text-slate-400 hover:text-emerald-600 transition">
                <i data-lucide="users" class="h-6 w-6"></i>
                <span class="text-[10px] font-medium">Anggota</span>
            </a>
            <div class="relative -top-6 flex justify-center">
                <a href="input_transaksi.php" class="w-14 h-14 bg-slate-900 rounded-full flex items-center justify-center text-white shadow-xl shadow-slate-900/30 border-4 border-white transform active:scale-95 transition">
                    <i data-lucide="plus" class="h-7 w-7"></i>
                </a>
            </div>
            <a href="riwayat.php" class="flex flex-col items-center justify-center gap-1 text-emerald-600">
                <i data-lucide="history" class="h-6 w-6 fill-current"></i>
                <span class="text-[10px] font-bold">Riwayat</span>
            </a>
            <button onclick="confirmLogout()" class="flex flex-col items-center justify-center gap-1 text-slate-400 hover:text-rose-500 transition">
                <i data-lucide="log-out" class="h-6 w-6"></i>
                <span class="text-[10px] font-medium">Keluar</span>
            </button>
        </div>
    </div>

    <script>
        lucide.createIcons();

        // --- NOTIFICATION HANDLER ---
        <?php if(isset($_SESSION['notif'])): ?>
            Swal.fire({
                icon: '<?= $_SESSION['notif']['type'] ?>',
                title: '<?= $_SESSION['notif']['title'] ?>',
                text: '<?= $_SESSION['notif']['text'] ?>',
                confirmButtonColor: '#10b981',
                confirmButtonText: 'Oke',
                customClass: { popup: 'rounded-3xl', confirmButton: 'rounded-xl px-6 py-3' }
            });
            <?php unset($_SESSION['notif']); ?>
        <?php endif; ?>

        // --- CONFIRM DELETE TRANSACTION ---
        function confirmDeleteTrx(id) {
            Swal.fire({
                title: 'Batalkan Transaksi?',
                text: "Saldo anggota akan dikembalikan otomatis ke nilai sebelum transaksi ini.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#f43f5e', // rose-500
                cancelButtonColor: '#e2e8f0', // slate-200
                confirmButtonText: 'Ya, Batalkan',
                cancelButtonText: '<span style="color:#64748b">Kembali</span>',
                customClass: { popup: 'rounded-3xl', confirmButton: 'rounded-xl', cancelButton: 'rounded-xl' }
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "riwayat.php?hapus=" + id;
                }
            })
        }

        // --- CONFIRM LOGOUT ---
        function confirmLogout() {
            Swal.fire({
                title: 'Keluar?',
                text: "Sesi anda akan berakhir.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#0f172a',
                cancelButtonColor: '#e2e8f0',
                confirmButtonText: 'Ya',
                cancelButtonText: '<span style="color:#64748b">Batal</span>',
                customClass: { popup: 'rounded-3xl', confirmButton: 'rounded-xl', cancelButton: 'rounded-xl' }
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "index.php?logout=true";
                }
            })
        }
    </script>
</body>
</html>